/*
* Za uneti orijentisani graf, proveriti da li je aciklican.
* Ako jeste, izvrsiti topolosko sortiranje.
* Ako nije, stampati vezu koja je napravila ciklus.
*/

#include <stdio.h>
#include <stdlib.h>

#define POVEZANO 1
#define NEPOVEZANO 0
#define IMA 1
#define NEMA 0
#define NEDEFINISANO -1

int time=0;
int ciklus=NEMA;

void dfsVisit(int **graf, int *d, int *f, int *topsort, int *br, int n, int u) 
{
	int v;
	
	time++;
	d[u] = time;
	
	for (v=0; v<n; v++) {
		if (graf[u][v]==POVEZANO) {
			if (d[v]==NEDEFINISANO) {
				dfsVisit(graf, d, f, topsort, br, n, v);
			}
			else if (f[v]==NEDEFINISANO) {
				ciklus=IMA;
				printf("Ciklus pravi veza (%d, %d)\n",u,v);
			}
		}
	}
	
	time++;
	f[u]=time;
	if (ciklus==NEMA) {
		topsort[*br] = u;
		(*br)--;
	}
	
}


main() {
	int **graf, *d, *f, *topsort;
	int n, l;
	int u, v;
	int i, j;
	int br;
	
	scanf("%d%d", &n, &l);
	
	graf = (int **)malloc(n*sizeof(int *));
	for (i=0; i<n; i++)
		graf[i] = (int *)malloc(n*sizeof(int));
	
	d = (int *)malloc(n*sizeof(int));
	f = (int *)malloc(n*sizeof(int));
	topsort = (int *)malloc(n*sizeof(int));
	
	for (i=0; i<n; i++)
		for (j=0; j<n; j++) {
			graf[i][j] = NEPOVEZANO;
		}
	
	for (i=0; i<l; i++) {
		scanf("%d%d", &u, &v);
		graf[u][v] = POVEZANO;
		// Za neorijentisan graf
		// graf[v][u] = POVEZANO;
	}
	
	for (i=0; i<n; i++) {
		d[i] = NEDEFINISANO;
		f[i] = NEDEFINISANO;
	}
	
	br=n-1;
	
	for (i=0; i<n; i++)
		if (d[i]==NEDEFINISANO)
			dfsVisit(graf, d, f, topsort, &br, n, i);
	
	printf("Ulazna vremena:\n");
	for (i=0; i<n; i++)
		printf("%d ", d[i]);
	printf("\n");
	
	printf("Izlazna vremena:\n");
	for (i=0; i<n; i++)
		printf("%d ", f[i]);
	printf("\n");
	
	if (ciklus==NEMA) {
		printf("Topoloski sortirani cvorovi:\n");
		for (i=0; i<n; i++)
			printf("%d ", topsort[i]);
		printf("\n");
	}
	else {
		printf("Ciklican graf.\n");
	}
	
	


}








