-- PROCEDURE

create procedure promenaRezultata
(
	@idMeca int,
	@poeni1 int,
	@poeni2 int,
	@statusMeca char(10)
)
as
begin
	update mecevi set poeni1=@poeni1,
	poeni2=@poeni2, statusMeca=@statusMeca
	where id=@idMeca
end

exec promenaRezultata 1, 0, 2, 'traje'
--pre indeksa 0.177, table update 7%-0.0118, table scan 93%-0.1654
--posle indeksa 0.0133

create procedure stanjeTiketa
(
	@idTiketa int
)
as
begin
	select m.vremeOdigravanja, m.tim1, m.tim2, m.poeni1, m.poeni2, m.statusMeca, 
		dobitak = case
					when m.poeni1>m.poeni2 and tm.tip='1' then 'dobija'
					when m.poeni1=m.poeni2 and tm.tip='X' then 'dobija'
					when m.poeni1<m.poeni2 and tm.tip='2' then 'dobija'
					else 'gubi'
				  end
	from tiketMec tm join mecevi m on tm.idMeca = m.id
	where tm.idTiketa = @idTiketa
end

exec stanjeTiketa 887
--pre indeksa 0.8059, table scan tiketMec 60%-0.4853, table scan mecevi 21%-0.1654, hash match 19%-0.155
--posle indeksa 0.0105

create procedure meceviUPeriodu
(
	@idLige int,
	@datumOd datetime,
	@datumDo datetime
)
as
begin
	select m.vremeOdigravanja, m.tim1, m.tim2, m.poeni1, m.poeni2, m.statusMeca, count(distinct t.idKlijenta)
	from tiketi t join tiketMec tm on t.id=tm.idTiketa
	join mecevi m on tm.idMeca=m.id
	where m.idLige=@idLige 
	and (@datumOd is null or (@datumOd is not null and m.vremeOdigravanja>=@datumOd) )
	and (@datumDo is null or (@datumDo is not null and m.vremeOdigravanja<=@datumDo) )
	group by m.id, m.vremeOdigravanja, m.tim1, m.tim2, m.poeni1, m.poeni2, m.statusMeca
end

exec meceviUPeriodu 204,'2013-08-15','2014-01-15'
--bez indeksa 2.24, 3*table scan, 2*hash match, distinct sort 1%-0.014, stream aggregate			
--table scan: mecevi 7%-0.1654, tiketMec 22%-0.4853, tiketi 9%-0.2037
--hash match: m i tm 45%-1.02, t 16%-0.35
--posle 0.38

create procedure dobitniTiketi
(
	@idKlijenta int
)
as
begin
	declare @ime nvarchar(50)
	declare @prezime nvarchar(50)
	declare @brojDobitnihTiketa int
	declare @idTiketa int
	declare @iznosUplate int
	declare @dobitak decimal(10,2)
	declare @proizvod decimal(10,2)
	set @dobitak = 0

	select @ime=ime, @prezime=prezime
	from klijenti
	where id=@idKlijenta

	declare tiketiZaKlijenta cursor for
	select id, iznosUplate
	from tiketi
	where idKlijenta=@idKlijenta and statusTiketa='dobitak'

	open tiketiZaKlijenta

	fetch next from tiketiZaKlijenta into @idTiketa, @iznosUplate
	set @brojDobitnihTiketa=0

	while @@FETCH_STATUS=0
	begin
		set @proizvod=@iznosUplate
		select @proizvod = 
				case
					when tm.tip='1' then @proizvod*m.kvota1
					when tm.tip='2' then @proizvod*m.kvota2
					else @proizvod*m.kvotaX
				end
		from tiketMec tm join mecevi m on tm.idMeca=m.id
		where tm.idTiketa=@idTiketa

		set @dobitak = @dobitak+@proizvod
		fetch next from tiketiZaKlijenta into @idTiketa, @iznosUplate
		set @brojDobitnihTiketa=@brojDobitnihTiketa+1
	end

	close tiketiZaKlijenta
	deallocate tiketiZaKlijenta

	select @ime, @prezime, @brojDobitnihTiketa, @dobitak
end

exec dobitniTiketi 9323
--bez indeksa 1.1296		
--table scan: klijenti 9%-0.1015, tiketi 18%-0.2037, tiketMec 43%-0.4853, mecevi 15%-0.1654
--hash match tm i m 14%-0.1552
--posle indeksa 0.0273

go


--INDEKSI

alter table klijenti
add constraint PK_id_cl primary key clustered (id)

create clustered index idx_cl_idtiketa_idmeca
on tiketMec (idTiketa, idMeca)

alter table tiketMec
add constraint PK_id_ncl primary key 

alter table lige
add constraint PK_id_lige primary key (id)

create clustered index idx_cl_idklijenta_statustiketa
on tiketi (idKlijenta, statusTiketa)

alter table tiketi
add constraint PK_id_ncl_tiketi primary key nonclustered (id)

alter table mecevi
add constraint PK_id_cl_mecevi primary key clustered (id)

create nonclustered index idx_ncl_idmeca_incl_idtiketa
on tiketMec (idMeca) include (idTiketa)

create nonclustered index idx_ncl_idlige_incl
on mecevi (idLige, vremeOdigravanja)


-- ANALIZA

exec promenaRezultata 1, 0, 2, 'traje'
exec stanjeTiketa 887
exec meceviUPeriodu 204,'2013-08-15','2014-01-15'
exec dobitniTiketi 9323

--zbirno bez indeksa  0.177 + 0.806 + 2.241 + 1.13  = 4.354
--zbirno sa indeksima 0.013 + 0.01  + 0.38  + 0.027 = 0.43

exec sp_spaceused klijenti
-- reserved 904KB, data 832KB, index 16KB
exec sp_spaceused lige
-- reserved 32KB, data 16KB, index 16KB
exec sp_spaceused mecevi
-- reserved 1944KB, data 1600KB, index 256KB
exec sp_spaceused tiketi
-- reserved 3152KB, data 1616KB, index 1320KB
exec sp_spaceused tiketMec
-- reserved 8280KB, data 3264KB, index 4824KB




