; Na osnovu opisnih ocena kvaliteta i gledanosti filma se odredjuje broj projekcija

(deftemplate OCENA_FILMA
	0 10 zvezdica
	(
		(los
			(Z 0 5)
		)
		(prosecan
			(PI 3 6)
		)
		(dobar
			(S 7 10)
		)
	)
)

(deftemplate GLEDANOST
	0 40 gledaoc
	(
		(mala
			(10 1)(25 0)
		)
		(velika
			(20 0)(35 1)
		)
	)
)

(defrule crtanje1
	=>
	(plot-fuzzy-value t "*+#" 0 10 
		(create-fuzzy-value OCENA_FILMA los)
		(create-fuzzy-value OCENA_FILMA prosecan)
		(create-fuzzy-value OCENA_FILMA dobar)
	)
)

(defrule crtanje2
	=>
	(plot-fuzzy-value t ".+" 0 40 
		(create-fuzzy-value GLEDANOST mala)
		(create-fuzzy-value GLEDANOST velika)
	)
)

(deftemplate film
	(slot naziv (type STRING))
	(slot brojProjekcija (type NUMBER)(default -1))
	(slot gledanost (type FUZZY-VALUE GLEDANOST))
	(slot ocena (type FUZZY-VALUE OCENA_FILMA))
)

(deftemplate projekcije
	(slot naziv (type STRING))
	(slot broj (type NUMBER))
)

(deffacts filmovi
	(film (naziv "Paklene ulice 8")(ocena prosecan)(gledanost velika))
	(film (naziv "Sila privlacnosti")(ocena los)(gledanost mala))
	(film (naziv "Strumpfovi")(ocena los)(gledanost velika))
	(film (naziv "Duh u oklopu")(ocena dobar)(gledanost mala))
	(film (naziv "Mali sef")(ocena prosecan)(gledanost mala))
	(film (naziv "Cuvari galaksije 2")(ocena dobar)(gledanost velika))
)

(defrule r1
	(film (naziv ?n) (brojProjekcija -1)(gledanost mala) (ocena los))
	=>
	(assert (projekcije (naziv ?n)(broj 0)))
)

(defrule r2
	(film (naziv ?n) (brojProjekcija -1)(gledanost mala) (ocena prosecan or dobar))
	=>
	(assert (projekcije (naziv ?n)(broj 1)))
)

(defrule r3
	(film (naziv ?n) (brojProjekcija -1)(gledanost velika))
	=>
	(assert (projekcije (naziv ?n)(broj 2)))
)

; Potvrdjujemo podatke sa visokim CF
(defrule r4
	?f1 <- (projekcije (naziv ?n)(broj ?br))
	?f2 <- (film (naziv ?n))
	(test (> (get-cf ?f1) 0.5))
	=>
	;(printout t ?n " " ?br crlf)
	(modify ?f2 (brojProjekcija ?br))
	(retract ?f1)
)

; Odbacujemo podatke sa niskim CF
(defrule r5
	?f <- (projekcije (naziv ?n)(broj ?br))
	(test (<= (get-cf ?f) 0.5))
	=>
	(retract ?f)
)

