(deftemplate film
	(slot naziv (type STRING))
	(slot broj-projekcija (type NUMBER))
	(multislot gledanost (type NUMBER))
	(slot prosek (type NUMBER)(default -1))
)

(deftemplate novi-film
	(slot naziv (type STRING))
	(slot zeljeni-broj-projekcija (type NUMBER))
)

; Dati su podaci o filmovima koji su se juce prikazivali u bioskopu i koliko karti je prodato za koju projekciju
; Stize novi film u bioskop i treba promeniti raspored projekcija

(deffacts bioskop
	(projekcija-dnevno 14)
	(film (naziv "Paklene ulice 8")(broj-projekcija 4)(gledanost 20 30 22 28))
	(film (naziv "Sila privlacnosti")(broj-projekcija 2)(gledanost 23 26))
	(film (naziv "Strumpfovi")(broj-projekcija 3)(gledanost 30 30 20))
	(film (naziv "Duh u oklopu")(broj-projekcija 2)(gledanost 10 8))
	(film (naziv "Mali sef")(broj-projekcija 3)(gledanost 11 8 9))
	(novi-film (naziv "Cuvari galaksije 2")(zeljeni-broj-projekcija 5))
)

(defglobal
	?*suma* = 0
)

(defrule pocetak
	=>
	(assert (racunaj-prosek))
)

;funkcija koja racuna prosecnu posecenost po projekciji

(deffunction daj-prosek (?br $?gledanost)
	(bind ?zbirno 0)
	(loop-for-count (?i 1 ?br) do
		(bind ?g (nth$ ?i $?gledanost))
		(bind ?zbirno (+ ?zbirno ?g))
	)
	(return (/ ?zbirno ?br))
)

(defrule proseci
	(racunaj-prosek)
	?f <- (film (broj-projekcija ?br)(gledanost $?g)(prosek -1))
	=>
	(modify ?f (prosek (daj-prosek ?br $?g)))
)

(defrule prelaz0
	?f <- (racunaj-prosek)
	(not (film (prosek -1)))
	=>
	(retract ?f)
	(assert (izbacivanje))
)

; film koji ima 1 ili 2 projekcije i ima posecenost manju od 10 po projekciji se brise
(defrule izbaci-film
	(izbacivanje)
	?f <- (film 
		(naziv ?n)
		(broj-projekcija ?br & :(<= ?br 2))
		(prosek ?p & :(and (< ?p 10) (> ?p -1)))
		;(gledanost $?g)
	)
	;(test (> (length$ $?g) 0))
	=>
	(retract ?f)
)

; filmu sa vise od 2 projekcije i slabom posecenoscu se smanjuje broj projekcija
(defrule smanji-film
	(izbacivanje)
	?f <- (film 
		(naziv ?n)
		(broj-projekcija ?br & :(> ?br 2))
		(prosek ?p & :(and (< ?p 10) (> ?p -1)))
		;(gledanost $?g)
	)
	;(test (> (length$ $?g) 0))
	=>
	(modify ?f (broj-projekcija (- ?br 1)) (gledanost) (prosek -1))
)

(defrule prelaz1
	(declare (salience -10))
	?f <- (izbacivanje)
	=>
	(retract ?f)
	(assert (brojanje))
)

; Nakon izbacivanja, broji se koliko termina projekcija je zauzeto
(defrule prebroj
	(brojanje)
	(film (broj-projekcija ?br))
	=>
	(bind ?*suma* (+ ?*suma* ?br))
)

; Koliko termina je ostalo slobodno
(defrule prelaz2
	(declare (salience -10))
	?f <- (brojanje)
	(projekcija-dnevno ?pd)
	=>
	(retract ?f)
	(assert (slobodno (- ?pd ?*suma*)))
)

; Da li novi film moze da se prikazuje sa zeljenim brojem projekcija
(defrule novi-film-moze
	?f1 <- (slobodno ?s)
	?f2 <- (novi-film (naziv ?n)(zeljeni-broj-projekcija ?zbr))
	(test (<= ?zbr ?s))
	=>
	(retract ?f2)
	(assert (film (naziv ?n)(broj-projekcija ?zbr)))
)

; Ako ne moze, onda uzme koliko mu je na raspolaganju
(defrule novi-film-ne-moze
	?f1 <- (slobodno ?s & :(> ?s 0))
	?f2 <- (novi-film (naziv ?n)(zeljeni-broj-projekcija ?zbr))
	(test (> ?zbr ?s))
	=>
	(retract ?f2)
	(assert (film (naziv ?n)(broj-projekcija ?s)))
)

(defrule ciscenje
	(not (novi-film))
	?f <- (film (prosek ?p & : (<> ?p -1)))
	=>
	(modify ?f (gledanost)(prosek -1))
)

(defrule kraj
	?f <- (slobodno ?)
	(not (film (prosek ?p & : (<> ?p -1))))
	=>
	(retract ?f)
)




