use knjizara
go


create procedure sp_novaProdaja(@sifraKnjige int, @brCKCitaoca int)
as
begin
	insert into prodaja(sifraKnjige,brCKCitaoca,vremeProdaje,obradjeno)
	values(@sifraKnjige, @brCKCitaoca, getdate(), 'ne')

	update knjige
	set stanje=stanje-1
	where sifra=@sifraKnjige
end
go


create procedure sp_onlineKupovina(@sifraKnjige int, @brCKCitaoca int)
as
begin
	declare @stanje int
	select @stanje=stanje
	from knjige
	where sifra=@sifraKnjige

	if @stanje>0
		exec sp_novaProdaja @sifraKnjige, @brCKCitaoca
	else
		print 'Nema knjige na stanju'
end
go

create procedure sp_presek
as
begin
	declare @iznos decimal(10,2)
	
	select @iznos=sum(placeno)
	from
	(select (case when p.brCKCitaoca is null then k.cena else (1-c.popust)*k.cena end) as placeno
	from prodaja p join knjige k 
	on p.sifraKnjige=k.sifra
	left join citaoci c
	on p.brCKCitaoca=c.brClanskeKarte
	where obradjeno='ne') as prodajaPlacanje
	
	print 'Pazar je ' + convert(varchar(10),@iznos)

	update prodaja
	set obradjeno='da'
	where obradjeno='ne'

end
go

create procedure sp_akcija(@granica int)
as
begin

	declare @brCKCitaoca int

	declare kursor_akcija cursor for
		select brCKCitaoca
		from prodaja
		where brCkCitaoca is not null and vremeProdaje>dateadd(MONTH,-1,getdate())
		group by brCkCitaoca
		having count(*)>=@granica

	open kursor_akcija

	fetch next from kursor_akcija
	into @brCKCitaoca

	while @@FETCH_STATUS = 0
	begin
		update citaoci
		set popust=popust+0.1
		where brClanskeKarte=@brCKCitaoca

		fetch next from kursor_akcija
		into @brCKCitaoca
	end

	close kursor_akcija
	deallocate kursor_akcija
end
go
