use telekom
go

create procedure sp_obracun
as
begin
	insert into racuni(idKorisnika, mesec, iznos)
		select idKorisnika, 
			convert(char(4), godina) + '-' + convert(char(2), mesec) + '-01', 
			iznos 
		from (
			select pozivOd as idKorisnika, 
				datepart(YEAR,vremePoziva) as godina,
				datepart(MONTH,vremePoziva) as mesec, 
				sum(cenaPoMinutu * datepart(minute, trajanje)) as iznos
			from saobracaj
			where obracunato = 0
			group by pozivOd, datepart(YEAR,vremePoziva), datepart(MONTH,vremePoziva)
		) as iznosRacuna

	update saobracaj
	set obracunato=1
	where obracunato=0
end
go
