use lutrija
go
create procedure sp_uplata
as
begin
	begin try
		set transaction isolation level
		serializable
		begin tran
			declare @serBroj int
			set @serBroj = floor(RAND()*900000 + 100000)
			while @serBroj in (select serBroj from listici)
			begin
				set @serBroj = floor(RAND()*900000 + 100000)
			end

			insert into listici(serBroj, obradjen)
			values (@serBroj, 'ne')
		commit tran
	end try
	begin catch
		print 'Uplata listica nije uspela, pokusajte ponovo.'
		rollback tran
	end catch
end

-- Posto sada procedura uplata ne dobija jedinstveni serijski broj kao parametar,
-- sada mora sama da ga generise.
-- Dve paralelne instance ove procedure mogu da generisu isti broj,
-- da provere u tabeli listici, vide da ga nema
-- i onda oba pokusaju da ubace listic sa istim serijskim brojem.
-- Ovu pojavu sprecava samo serializable.
-- Tada select stavlja S lock nad celom tabelom i blokira insert druge transakcije.
-- Ako obe transakcije urade select, pa pokusaju da urade insert,
-- doci ce do deadlock-a.