use lutrija
go

create procedure sp_fond
(
	@cena int
)
as
begin
	begin try
		set transaction isolation level
		serializable
		begin tran
			declare @fond int, @brKola int
			select @fond=count(*)*@cena
			from listici
			where obradjen='ne'

			select @brKola=max(brKola)
			from kolo

			set @brKola = @brKola + 1

			insert into kolo (brKola, fond, isplaceno)
			values(@brKola, @fond, 0)

			update listici
			set obradjen='da'
			where obradjen='ne'
		commit tran
	end try
	begin catch
		print 'Obrada listica i racunanje nagradnog fonda se nisu izvrsili. Pokusajte ponovo.'
		rollback tran
	end catch
end

-- Ako ova transakcija ima manji nivo od serializable,
-- moze da se desi da procita sve neobradjene
-- i izracuna nagradni fond na osnovu toga,
-- a da se u medjuvremenu izvrsi nova uplata
-- koja ne udje u nagradni fond, a uplati se za tekuce kolo,
-- a update na kraju ove procedure onda i taj novi listic postavi kao obradjen.
-- U zadatku je receno da se uplata ovakvih listica mora odloziti do kraja obracuna fonda
-- i nakon toga se uplatiti za sledece kolo.
-- Insert iz uplate se moze blokirati jedino nivoom serializable.
-- Nakon obracuna fonda, insert se odblokira, izvrsava,
-- a taj listic ce biti posmatran za naredno kolo.

