use lutrija
go
create procedure sp_arhiviranje
as
begin
	begin try
		set transaction isolation level
		read committed
		begin tran
			declare @idListica int, @iznos int, @kolo int, @br int
			set @br=0
			save tran sp

			declare kursor_arhiva cursor for
			select idListica, iznos, kolo
			from dobici
			where isplaceno='da'

			open kursor_arhiva

			fetch next from kursor_arhiva
			into @idListica, @iznos, @kolo

			while @@FETCH_STATUS = 0
			begin
				delete from dobici
				where idListica = @idListica

				insert into arhiva(idListica, iznos, kolo)
				values (@idListica, @iznos, @kolo)

				set @br=@br+1
				if @br%5=0
				begin
					save tran sp
				end

				fetch next from kursor_arhiva
				into @idListica, @iznos, @kolo
			end

		commit tran
	end try
	begin catch
		print 'Arhiviranje nije uspelo, pokusajte ponovo.'
		rollback tran sp
	end catch
	
	close kursor_arhiva
	deallocate kursor_arhiva
	commit tran
end

-- Ne moze da utice na isplatu i ponistavanje jer radi sa isplacenima.
-- Ako stavimo read uncommitted, moze da se desi da se isplaceni listic obrise i arhivira,
-- a da se onda isplata rollback-uje. 
-- Korsinik nakon toga vise nece moci da naplati svoj dobitak, jer ce biti arhiviran.