use lutrija
go

create procedure sp_isplata
(
	@idListica int
)
as
begin
	begin try
		set transaction isolation level
		repeatable read
		begin tran
			declare @iznos int, @kolo int
			select @iznos=iznos, @kolo=kolo
			from dobici
			where idListica=@idListica
			and isplaceno='ne'

			if @iznos is not null
			begin
				update kolo
				set isplaceno = isplaceno + @iznos
				where brKola=@kolo

				update dobici
				set isplaceno='da'
				where idListica=@idListica
			end
		commit tran
	end try
	begin catch
		print 'Isplata nije uspela, pokusajte ponovo'
		rollback tran
	end catch
end

-- Ako stavimo read committed,
-- i procitamo da dobitak moze biti isplacen
-- ponistavanje moze u medjuvremenu da obrise dobitak
-- a da se uprkos tome isplata izvrsi i isplacen iznos poveca.
-- Dakle, imacemo isplatu, a necemo imati taj dobitak u arhivi.
-- Ako stavimo repeatable read,
-- citanje dobitka postavlja S lock do kraja transakcije
-- i brisanje nece moci da se izvrsi,
-- zapravo dolazi do deadlock-a, jer delete prvo cita u where.