use lutrija
go

create procedure sp_ponistavanje
(
	@brKola int
)
as
begin
	begin try
		set deadlock_priority high
		set transaction isolation level
		read uncommitted
		begin tran
			delete from dobici
			where kolo=@brKola and isplaceno='ne'
		commit tran
	end try
	begin catch
		print 'Ponistavanje nije uspelo, pokusajte ponovo'
		rollback tran
	end catch
end

-- Nivo izolacije je ovde nebitan, ne utice ni na sta.
-- Imamo samo jednu delete operaciju, nemoguce je napraviti joj anomaliju.

-- Deadlock prirority je high zato sto moze doci do dedalock-a sa isplatom.
-- Isplata se izvrsava cesto, a ponistavanje jednom nedeljno, tako da je ponistavanje bitnije.