/*
 * Na ulazu se daje broj Web strana (n) i broj
 * njihovih povezanosti linkovima (l, orijentisano).
 * Zatim se daju povezanosti, pocetna strana i
 * maksimalna dozvoljena dubina.
 * Odrediti strane cija je dubina veca od dozvoljene.
*/
#include <stdio.h>
#include <stdlib.h>

#define POVEZANO 1
#define NEPOVEZANO 0
#define NEDEFINISANO (-1)
#define PRAZNO (-1)

typedef struct element {
	int cvor;
	struct element *sledeci;
} Element;

//dodavanje na red
void dodaj(Element **pocetak, Element **kraj, int i) {
	Element *temp;
	temp = (Element *)malloc(sizeof(Element));
	temp->cvor = i;
	temp->sledeci = NULL;
	if (*pocetak==NULL) {
		*pocetak = *kraj = temp;
	}
	else {
		(*kraj)->sledeci = temp;
		*kraj = temp;
	}
}

//skidanje sa reda
int skini(Element **pocetak, Element **kraj) {
	int cvor;
	Element *temp;
	if (*pocetak==NULL) {
		return PRAZNO;
	}
	else {
		temp = *pocetak;
		*pocetak = temp->sledeci;
		cvor = temp->cvor;
		if (*kraj==temp) *kraj=NULL;
		free(temp);
		return cvor;
	}
}

int main() {

	// TODO

}
