create procedure sp_tekuciMesec
(
	@idKorisnika int
)
as
begin
	select sum(t.cenaPoMinutu * datepart(minute, s.trajanje))
	from saobracaj s join tarife t
	on s.idTarife = t.id
	where s.pozivOd = @idKorisnika
	and datepart(MONTH,s.vremePoziva)=datepart(MONTH,GETDATE())
end
go

exec sp_tekuciMesec 1
go


create procedure sp_obracun
as
begin
	insert into racuni(idKorisnika, mesec, iznos)
		select idKorisnika, 
			convert(char(4), godina) + '-' + convert(char(2), mesec) + '-01', 
			iznos 
		from (
			select s.pozivOd as idKorisnika, 
				datepart(YEAR,s.vremePoziva) as godina,
				datepart(MONTH,s.vremePoziva) as mesec, 
				sum(t.cenaPoMinutu * datepart(minute, s.trajanje)) as iznos
			from saobracaj s join tarife t
			on s.idTarife = t.id
			where obracunato = 0
			group by s.pozivOd, datepart(YEAR,s.vremePoziva), datepart(MONTH,s.vremePoziva)
		) as iznosRacuna

	update saobracaj
	set obracunato=1
	where obracunato=0
end
go

exec sp_obracun
go


create procedure sp_poziv
(
	@pozivOd int, @pozivKa int, @trajanje time, @idTarife int, @vremePoziva smalldatetime		
)
as
begin
	insert into saobracaj(pozivOd, pozivKa, trajanje, idTarife, vremePoziva,obracunato)
	values(@pozivOd, @pozivKa, @trajanje, @idTarife, @vremePoziva, 0)
end
go

exec sp_poziv 1000, 2000, '00:10:00', 1, '2016-12-25 15:00:00'
go


create procedure sp_najveciRacuni
as
begin
	select k.ime, k.brojTelefona, r.iznos
	from racuni r join korisnici k
	on r.idKorisnika = k.id
	where r.datumUplate is null
	order by r.iznos desc
end
go

exec sp_najveciRacuni
go


create procedure sp_ugovori
as
begin
	select ime, datumIstekaUgovora
	from korisnici k
	order by datumIstekaUgovora
end
go

exec sp_ugovori
go