create procedure sp_nova_ponuda
(
	@idKorisnika int,
	@idAukcije int,
	@iznosPonude decimal(8,2)
)
as
begin
	declare @maxIznos decimal(8,2)
	select top 1 @maxIznos=iznosPonude
	from ponude
	where idAukcije = @idAukcije
	order by vremePonude desc

	declare @status varchar(10), @pocetnaCena decimal(8,2)
	select @status=status, @pocetnaCena=pocetnaCena
	from aukcije
	where id = @idAukcije

	if (@status = 'otvorena')
	begin
		if (@maxIznos is null and @iznosPonude >= @pocetnaCena) or 
			(@maxIznos is not null and @iznosPonude > @maxIznos)
			insert into ponude(idKupca, idAukcije, iznosPonude, vremePonude, statusPonude)
			values(@idKorisnika, @idAukcije, @iznosPonude, getdate(), 'prihvaceno')
		else
			print 'Vasa ponuda nije veca od aktuelne.'
	end
	else
		print 'Aukcija je zatvorena.'
end
go

exec sp_nova_ponuda 2, 3, 5200
go


create procedure sp_aktuelna_ponuda
(
	@idAukcije int
)
as
begin
	declare @aktuelnaPonuda decimal(8,2)
	declare @pocetnaCena decimal(8,2)
	declare @status varchar(10)
	declare @vremeZatvaranja datetime
	
	select top 1 @aktuelnaPonuda=iznosPonude
	from ponude
	where idAukcije = @idAukcije
	order by vremePonude desc

	select @pocetnaCena=pocetnaCena, @status=status, @vremeZatvaranja=vremeZatvaranja
	from aukcije
	where id = @idAukcije

	if @status='zatvorena'
		print 'Aukcija je zatvorena!'
	else 
	begin
		print 'Aukcija traje do ' + convert(varchar(50), @vremeZatvaranja)
		if @aktuelnaPonuda is null
		begin
			print 'Uputi prvu ponudu!'
			set @aktuelnaPonuda = @pocetnaCena
		end
	end
	print 'Aktuelna ponuda: ' + convert(varchar(11), @aktuelnaPonuda)
end
go

exec sp_aktuelna_ponuda 1
exec sp_aktuelna_ponuda 2
exec sp_aktuelna_ponuda 3
go


create procedure sp_sve_prihvacene_ponude
(
	@idAukcije int
)
as
begin
	select k.username, p.iznosPonude, p.vremePonude
	from ponude p join korisnici k
	on k.id = p.idKupca
	where p.idAukcije = @idAukcije
	order by p.vremePonude desc
end
go

exec sp_sve_prihvacene_ponude 1
go


create procedure sp_zatvaranje
(
	@idAukcije int
)
as
begin
	update aukcije
	set status = 'zatvorena'
	where id = @idAukcije

	declare @idPonude int
	select top 1 @idPonude=id
	from ponude
	where idAukcije = @idAukcije
	order by vremePonude desc
	
	update ponude
	set statusPonude='pobednik'
	where id = @idPonude
end
go

exec sp_zatvaranje 2
go


create procedure sp_naplata
(
	@idKlijenta int,
	@idAukcije int
)
as
begin
	declare @iznosNaRacunu decimal(8,2)
	select @iznosNaRacunu=iznosNaRacunu
	from korisnici
	where id=@idKlijenta

	declare @statusAukcije varchar(10)
	declare @idProdavca int
	select @statusAukcije=status, @idProdavca=idProdavca
	from aukcije
	where id=@idAukcije

	declare @iznosPonude decimal(8,2)
	declare @kupacPobednik int
	select @iznosPonude=iznosPonude, @kupacPobednik=idKupca
	from ponude
	where idAukcije = @idAukcije and
	statusPonude = 'pobednik'

	if @statusAukcije='zatvorena' and @kupacPobednik=@idKlijenta and @iznosPonude <= @iznosNaRacunu
	begin
		update korisnici
		set iznosNaRacunu = iznosNaRacunu - @iznosPonude
		where id = @kupacPobednik

		update korisnici
		set iznosNaRacunu = iznosNaRacunu + @iznosPonude
		where id = @idProdavca

		update aukcije
		set status = 'naplacena'
		where id=@idAukcije
	end
	else
	begin
		print 'Doslo je do greske'
	end
end
go

exec sp_naplata 3, 1