﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApplication4
{
    public partial class Form1 : Form
    {
        Random r = new Random();
        Button[] b = new Button[9];
        int k = 3; // koliko polja treba da bude otkriveno
        int otkrivena = 0; // koliko je trenutno polja/dugmica prikazano
        List<int> tacno = new List<int>(); // redni brojevi dugmica na koje treba kliknuti bas tim redom
        List<int> pokusaji = new List<int>(); // pokusaj igraca, kojim redom je na koje dugmice kliknuo

        public Form1()
        {
            InitializeComponent();
            b[0] = Polje0; b[1] = Polje1; b[2] = Polje2;
            b[3] = Polje3; b[4] = Polje4; b[5] = Polje5;
            b[6] = Polje6; b[7] = Polje7; b[8] = Polje8; 
        }

        private void button1_Click(object sender, EventArgs e)
        {
            ocisti_tablu();
            ocisti_liste();
            OtkrivanjeTimer.Start();
        }

        private void ocisti_tablu()
        {
            foreach (Button x in b)
            {
                x.Visible = false;
                x.Text = "";
                x.Enabled = false;
            }
        }

        private void ocisti_liste()
        {
            otkrivena = 0;
            tacno.Clear();
            pokusaji.Clear();
        }

        private void OtkrijPolje()
        {   
            int br = r.Next(9);
            while ((b[br].Visible == true) && (otkrivena < 9)) br = r.Next(9);
            b[br].Visible = true;
            b[br].Text = "" + otkrivena;
            tacno.Add(br);
            otkrivena++;
        }

        private void OtkrivanjeTimer_Tick(object sender, EventArgs e)
        {

            if (otkrivena == k)
            {
                stoperica.Start();  // pocinje merenje vremena za pogadjanje
                foreach (int br in tacno)
                {
                    b[br].Text = "";
                    b[br].Enabled = true;
                }
                OtkrivanjeTimer.Stop();
                return;
            }
            OtkrijPolje();
        }

        private void stoperica_Tick(object sender, EventArgs e)
        {
            if (pokusaji.Count == 0) return;
            stoperica.Stop();
            if (pokusaji.Count < k) return;
            int pogodjeno = 0; 
            for (int i = 0; i < k; i++) if (tacno[i] == pokusaji[i]) pogodjeno++;
            if ((pogodjeno == k) && (k < 9)) {
                k++;
                ocisti_tablu();
                ocisti_liste();
                stoperica.Interval += 200;
                OtkrivanjeTimer.Start();
                return;
            }
            if ((k == 9) && (pogodjeno == k))
            {
                MessageBox.Show("Nova igra?");
                // Za domaci: na osnovu odgovora odluciti da li igra pocinje od pocetka
                // ili se zatvara prozor aplikacije
                return;
            }
            if (pogodjeno<k)
            {
                k=3;
                stoperica.Interval = 2000;
                MessageBox.Show("Pogresno. Nova igra?");
                // Za domaci: na osnovu odgovora odluciti da li igra pocinje od pocetka
                // ili se zatvara prozor aplikacije
                ocisti_tablu();
                ocisti_liste();
                OtkrivanjeTimer.Start();
            }
        }

        private void Polje0_Click(object sender, EventArgs e)
        {
            pokusaji.Add(0);
            Polje0.Enabled = false;
        }

        private void Polje1_Click(object sender, EventArgs e)
        {
            pokusaji.Add(1);
            Polje1.Enabled = false;
        }

        private void Polje2_Click(object sender, EventArgs e)
        {
            pokusaji.Add(2);
            Polje2.Enabled = false;
        }

        private void Polje3_Click(object sender, EventArgs e)
        {
            pokusaji.Add(3);
            Polje3.Enabled = false;
        }

        private void Polje4_Click(object sender, EventArgs e)
        {
            pokusaji.Add(4);
            Polje4.Enabled = false;
        }

        private void Polje5_Click(object sender, EventArgs e)
        {
            pokusaji.Add(5);
            Polje5.Enabled = false;
        }

        private void Polje6_Click(object sender, EventArgs e)
        {
            pokusaji.Add(6);
            Polje6.Enabled = false;
        }

        private void Polje7_Click(object sender, EventArgs e)
        {
            pokusaji.Add(7);
            Polje7.Enabled = false;
        }

        private void Polje8_Click(object sender, EventArgs e)
        {
            pokusaji.Add(8);
            Polje8.Enabled = false;
        }


    }
}
