;template-ovi
(deftemplate utisak
	(slot ime (type STRING))
	(slot destinacija (type SYMBOL))
	(slot ocena (allowed-values pozitivna negativna))
)

(deftemplate zbirni_utisak
	(slot destinacija (type SYMBOL))
	(slot pozitivni (type INTEGER))
	(slot negativni (type INTEGER))
	(slot ukupno (type NUMBER) (default 0.0))
)

(deftemplate ponuda
	(slot destinacija (type SYMBOL))
	(slot br_dana (type INTEGER))
	(slot cena (type NUMBER))
)

;pravljenje zbirnog utiska
;zbirni utisak ne postoji
(defrule zbirni_ne_postoji
	?f <- (utisak (destinacija ?destinacija) (ocena ?ocena))
	(not (zbirni_utisak (destinacija ?destinacija)))
		=>
	(if (eq ?ocena pozitivna) 
		then (assert (zbirni_utisak (destinacija ?destinacija) (pozitivni 1) (negativni 0)))
		else (assert (zbirni_utisak (destinacija ?destinacija) (pozitivni 0) (negativni 1)))
	)
	(retract ?f)
)

;zbirni utisak postoji
(defrule zbirni_postoji
	?f <- (utisak (destinacija ?destinacija) (ocena ?ocena))
	?zu <- (zbirni_utisak (destinacija ?destinacija) (pozitivni ?pozitivni) (negativni ?negativni))
		=>
	(if (eq ?ocena pozitivna)
		then (modify ?zu (pozitivni (+ 1 ?pozitivni)))
		else (modify ?zu (negativni (+ 1 ?negativni)))
	)
	(retract ?f)
)

;prelazak na racunanje proseka
(defrule predji_na_racun
	(not (utisak (destinacija ?destinacija)))
		=>
	(assert (racunaj-proseke))
)

;racunanje proseka
(defrule racunaj_proseke
	(racunaj-proseke)
	?f <- (zbirni_utisak (destinacija ?destinacija) (pozitivni ?pozitivni) (negativni ?negativni) (ukupno 0.0))
		=>
	(modify ?f (ukupno (/ (- ?pozitivni ?negativni) ?pozitivni)))
)

;prelazak na izbacivanje neisplativih
(defrule predji_na_izbacivanje
	(declare (salience -10))
	?f <- (racunaj-proseke)
		=>
	(retract ?f)
	(assert (izbaci-neisplative))
)

;pronalazenje neisplativih
(defrule izbaci_neisplative
	(izbaci-neisplative)
	?z <- (zbirni_utisak (destinacija ?destinacija) (ukupno ?ukupno))
	(test (< ?ukupno -0.5))
	?f <- (ponuda (destinacija ?destinacija))
		=>
	(retract ?z)
	(retract ?f)
)

;prelazak na formiranje cena
(defrule predji_na_cene
	(declare (salience -10))
	?f <- (izbaci-neisplative)
		=>
	(retract ?f)
	(assert (racunaj-cene))
)

;formiranje cena
;funkcija za formiranje cena
(deffunction formiraj_cene
	(?stara_cena ?opsti_utisak ?pozitivni)
	
	(if (and (> ?opsti_utisak 0.5) (> ?pozitivni 15))
		then (return (* 1.2 ?stara_cena))
	)
	(if (and (> ?opsti_utisak 0.5) (< ?pozitivni 16))
		then (return (* 1.1 ?stara_cena))
	)
	(if (and (> ?opsti_utisak 0) (< ?opsti_utisak 0.5) (> ?pozitivni 10))
		then (return (* 1.03 ?stara_cena))
	)
	(if (and (> ?opsti_utisak -0.5) (< ?opsti_utisak 0.0))
		then (return (* 0.85 ?stara_cena))
	)
	(return ?stara_cena)
)

;pravilo za racunanje cena
(defrule racun_cene
	(racunaj-cene)
	?f <- (zbirni_utisak (destinacija ?destinacija) (pozitivni ?pozitivni) (negativni ?negativni) (ukupno ?ukupno))
	?po <- (ponuda (destinacija ?destinacija) (cena ?stara_cena))
		=>
	(bind ?nova_cena (formiraj_cene ?stara_cena ?ukupno ?pozitivni))
	(modify ?po (cena ?nova_cena))
	(retract ?f)
)

;zavrsetak racunanja cena
(defrule listaj_detalje
	(declare (salience -10))
	?f <- (racunaj-cene)
		=>
	(retract ?f)
	(assert (listaj-destinacije))
)

;izlistavanje detalja
(defrule spisak_destinacija
	(listaj-destinacije)
	(ponuda (destinacija ?destinacija))
		=>
	(printout t "Destinacija: " ?destinacija crlf)
)

;ucitavanje destinacije i prelazak na izlistavanje detalja
(defrule odabir_destinacije
	(declare (salience -10))
	?f <- (listaj-destinacije)
		=>
	(printout t "Da li zelite vise detalja o nekoj destinaciji? da/ne" crlf)
	(bind ?odgovor (read))
	(if (eq ?odgovor da)
		then 
			(printout t "Unesite naziv destinacije." crlf)
			(bind ?zeljena (read))
			(assert (zeljena ?zeljena))
			(retract ?f)
		
	)
)

;destinacija postoji
(defrule detalji_postojece
	?f <- (zeljena ?destinacija)
	(ponuda (destinacija ?destinacija) (br_dana ?dani) (cena ?cena))
		=>
	(printout t "Detalji o " ?destinacija crlf)
	(printout t "Broj dana: " ?dani crlf)
	(printout t "Cena: " ?cena crlf)
	(assert (listaj-destinacije))
)

;cinjenice
(deffacts pojedinacni
	(utisak (ime "Pera Mikic") (destinacija Krit) (ocena pozitivna))
	(utisak (ime "Mika Lazic") (destinacija Mikonos) (ocena negativna))
	(utisak (ime "Pera Lazic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Laza") (destinacija Hurgada) (ocena negativna))
	(utisak (ime "Milena") (destinacija Hurgada) (ocena pozitivna))
	(utisak (ime "Pera") (destinacija Krit) (ocena pozitivna))
	(utisak (ime "Anja M") (destinacija Krit) (ocena negativna))
	(utisak (ime "Jelena K") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Momcilo Jankovic") (destinacija Paralija) (ocena negativna))
	(utisak (ime "Petra Cvijic") (destinacija Paralija) (ocena pozitivna))
	(utisak (ime "Lena Cvetkovic") (destinacija Krit) (ocena negativna))
	(utisak (ime "Kristina") (destinacija Krit) (ocena negativna))
	(utisak (ime "Luka") (destinacija Krit) (ocena negativna))
	(utisak (ime "Mina Milovic") (destinacija Krit) (ocena negativna))
	(utisak (ime "Mina Jovanovic") (destinacija Krit) (ocena negativna))
	(utisak (ime "Laza Peric") (destinacija Krit) (ocena negativna))
	(utisak (ime "Mika Markovic") (destinacija Krit) (ocena negativna))
	(utisak (ime "Mika Milosevic") (destinacija Krit) (ocena negativna))
	(utisak (ime "Pera Markovic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Lazar Lazic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Milos Lazic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Katarina Lazic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Vuk Lazic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Lazar Veljkovic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Savic Mitar") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Petar Petrovic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Milos Vucevic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Slobodan Lazovic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Svetlana Savic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Mitar Markovic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Marko Petrovic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Milos Lazarevic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Petra Ilic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Milica Aleksandrovic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Milos Milosevic") (destinacija Mikonos) (ocena pozitivna))
	(utisak (ime "Nevena Lazarevic") (destinacija Mikonos) (ocena pozitivna))
)

(deffacts ponude
	(ponuda (destinacija Krit) (br_dana 10) (cena 100))
	(ponuda (destinacija Mikonos) (br_dana 10) (cena 100))
	(ponuda (destinacija Hurgada) (br_dana 10) (cena 100))
	(ponuda (destinacija Paralija) (br_dana 10) (cena 100))
)