;definisanje promenljivih
(deftemplate POPULARNOST
	1 10
	(
		(nepopularna (Z 2 4))
		(prosecna (PI 2 5))
		(popularna (S 6 8))
	)
)

(deftemplate SIGURNOST
	0 20
	(
		(nesigurna (5 1) (8 0))
		(prosecna (7 0) (10 1) (13 0))
		(sigurna (12 0) (15 1))
	)
)

(deftemplate OCENA
	1 5
	(
		(neinteresantna (Z 1 3))
		(srednje_interesantna (PI 1 3))
		(obavezna (S 3 5))
	)
)

;crtanje promenljivih
(defrule crtanje
		=>
	(plot-fuzzy-value t "*#+" 1 10
		(create-fuzzy-value POPULARNOST nepopularna)
		(create-fuzzy-value POPULARNOST prosecna)
		(create-fuzzy-value POPULARNOST popularna)
	)
	(plot-fuzzy-value t "*#+" 0 20
		(create-fuzzy-value SIGURNOST nesigurna)
		(create-fuzzy-value SIGURNOST prosecna)
		(create-fuzzy-value SIGURNOST sigurna)
	)
	(plot-fuzzy-value t "*#+" 1 5
		(create-fuzzy-value OCENA neinteresantna)
		(create-fuzzy-value OCENA srednje_interesantna)
		(create-fuzzy-value OCENA obavezna)
	)
)

;definisanje sablona destinacija i preporuka
(deftemplate destinacija
	(slot naziv (type SYMBOL))
	(slot popularnost (type FUZZY-VALUE POPULARNOST))
	(slot sigurnost (type FUZZY-VALUE SIGURNOST))
)

(deftemplate preporuka
	(slot ime_destinacije (type SYMBOL))
	(slot ocena (type FUZZY-VALUE OCENA))
)

;definisanje pravila
(defrule popularna_sigurna
	(destinacija (naziv ?naziv) (popularnost popularna) (sigurnost sigurna))
		=>
	(assert (preporuka (ime_destinacije ?naziv) (ocena obavezna)))
)

(defrule srednje-interesantna
	(destinacija (naziv ?naziv) (popularnost nepopularna) (sigurnost sigurna))
		=>
	(assert (preporuka (ime_destinacije ?naziv) (ocena srednje_interesantna)))
)

(defrule nesigurna
	(destinacija (naziv ?naziv) (sigurnost nesigurna))
		=>
	(assert (preporuka (ime_destinacije ?naziv) (ocena neinteresantna)))
)

(defrule predji_na_defazifikaciju
	(declare (salience -10))
		=>
	(assert (defazifikuj))
)

(defrule defazifikacija
	(defazifikuj)
	?f <- (preporuka (ime_destinacije ?destinacija) (ocena ?ocena))
		=>
	(printout t "Ocena destinacije: " ?destinacija " " (moment-defuzzify ?ocena) " sa sigurnoscu " (get-cf ?f) crlf)
	
)

(deffacts destinacije
	(destinacija (naziv Turska) (popularnost popularna) (sigurnost prosecna))
	(destinacija (naziv Sirija) (popularnost popularna) (sigurnost nesigurna))
	(destinacija (naziv Indija) (popularnost prosecna) (sigurnost prosecna))
	(destinacija (naziv Egipat) (popularnost popularna) (sigurnost nesigurna))
	(destinacija (naziv SA) (popularnost nepopularna) (sigurnost prosecna))
	(destinacija (naziv Kuvajt) (popularnost nepopularna) (sigurnost sigurna))
	(destinacija (naziv Maroko) (popularnost prosecna) (sigurnost sigurna))
	(destinacija (naziv Grcka) (popularnost popularna) (sigurnost sigurna))
	(destinacija (naziv Italija) (popularnost popularna) (sigurnost prosecna))
	(destinacija (naziv Spanija) (popularnost popularna) (sigurnost sigurna))
	(destinacija (naziv Portugal) (popularnost prosecna) (sigurnost sigurna))
)













