use isporuke
go

create procedure sp_porudzbina
(
	@idKlijenta int,
	@idProizvoda int
)
as
begin
	declare @stanjeProizvoda int
	select @stanjeProizvoda = stanje
	from proizvodi
	where id=@idProizvoda

	if @stanjeProizvoda=0
	begin
		print 'Trazenog proizvoda trenutno nema na stanju.'
	end
	else
	begin
		update proizvodi
		set stanje = stanje-1
		where id=@idProizvoda

		insert into porudzbine(idKlijenta, idProizvoda)
		values(@idKlijenta, @idProizvoda)

	end
end
go


create procedure sp_utovar
(
	@idPorudzbine int
)
as
begin
	declare @zapremina decimal(10,2), @idKamiona int

	select @zapremina=pro.zapremina
	from porudzbine por join proizvodi pro
	on por.idProizvoda = pro.id
	where por.id = @idPorudzbine

	select top 1 @idKamiona=id
	from kamioni
	where status='utovar' and slobodno>=@zapremina
	order by slobodno

	if @idKamiona is null
	begin
		print 'Trenutno nema mesta ni u jednom kamionu.'
	end
	else
	begin
		update kamioni
		set slobodno = slobodno - @zapremina
		where id = @idKamiona

		update porudzbine
		set idKamiona = @idKamiona
		where id = @idPorudzbine
	end
end
go


create procedure sp_salji_kamione
as
begin
	declare @idKamiona int

	declare kursor_kamioni cursor for
	select id
	from kamioni
	where status='utovar' 
	and 1.0*slobodno/nosivost < 0.2

	open kursor_kamioni

	fetch next from kursor_kamioni
	into @idKamiona

	while @@FETCH_STATUS = 0
	begin
		update kamioni
		set status = 'isporucuje'
		where id=@idKamiona

		update porudzbine
		set datumIsporuke = GETDATE()
		where idKamiona = @idKamiona

		fetch next from kursor_kamioni
		into @idKamiona
	end

	close kursor_kamioni
	deallocate kursor_kamioni
end
go


create procedure sp_povratak_kamiona
(
	@idKamiona int
)
as
begin
	update kamioni
	set status = 'utovar', slobodno=nosivost
	where id=@idKamiona
end
go


create procedure sp_stanje_porudzbina
as
begin
	select kl.ime, kl.adresa, pro.naziv,
	case  
		when por.idKamiona is null then 'naruceno'
		else 'utovareno'
	end as status
	from porudzbine por
	join klijenti kl on por.idKlijenta=kl.id
	join proizvodi pro on por.idProizvoda=pro.id
	where por.datumIsporuke is null
end
go

