#include <stdio.h>
#include <stdlib.h>

#define PASSAGE 1
#define WALL 0

#define UNDEFINED (-1)
#define EMPTY (-1)

#define TRUE 1
#define FALSE 0

typedef struct element {
	int cvor;
	struct element *sledeci;
} Element;

//dodavanje na red
void dodaj(Element **pocetak, Element **kraj, int i) {
	Element *temp;
	temp = (Element *)malloc(sizeof(Element));
	temp->cvor = i;
	temp->sledeci = NULL;
	if (*pocetak==NULL) {
		*pocetak = *kraj = temp;
	}
	else {
		(*kraj)->sledeci = temp;
		*kraj = temp;
	}
}

//skidanje sa reda
int skini(Element **pocetak, Element **kraj) {
	int cvor;
	Element *temp;
	if (*pocetak==NULL) {
		return EMPTY;
	}
	else {
		temp = *pocetak;
		*pocetak = temp->sledeci;
		cvor = temp->cvor;
		if (*kraj==temp) *kraj=NULL;
		free(temp);
		return cvor;
	}
}



// ------------------------


// TO DO PATH

// void printPath(int **graf, int s, int v, int *preth)
// {
//     if (s == v)
//     {
//         printf("%d ", s);
//     }
//     else if (preth[v] == NEDEFINISANO)
//     {
//         printf("Nema puta od %d do %d", s, v);
//     }
//     else
//     {
//         printPath(graf, s, preth[v], preth);
//         printf("%d ", v);
//     }
// }

void drawMaze(int **graf, int m, int n)
{
    int i, j;

    for (i = 0; i < m; i++)
    {
        for (j = 0; j < n; j++)
        {
            if (graf[i][j] == WALL)
                printf("*");
            else
                printf(" ");
        }
        printf("\n");
    }
}

int main(int argc, char const *argv[])
{
    
    int m, n;
    scanf("%d%d", &m, &n);

    int **graf;
    graf = (int **)malloc(m*sizeof(int *));
    int i, j;
    for( i = 0; i < m; i++)
    {
        graf[i] = (int *)malloc(n*sizeof(int));
    }

    // laod maze
    char c = getchar();
    int startI, startJ, endI, endJ;
    for( i = 0; i < m; i++)
    {
        for( j = 0; j < n; j++)
        {
            c = getchar();       
            if (c == '@') {
                graf[i][j] = WALL;
            }
            else
            {
                graf[i][j] = PASSAGE;
                
                if (c == '*') {
                    startI = i;
                    startJ = j;
                }else if (c == '#'){
                    endI = i;
                    endJ = j;
                }
            }
        }
        getchar();
    }

    printf("\n");
    drawMaze(graf, m, n);
    printf("\n");

    return 0;
}
