import bs4, os, csv, json

def obradiOdeljenje(filename):
    jsonFile = open(filename)
    odeljenje = json.loads(jsonFile.read())

    ucenici = odeljenje['studenti']

    maxProsek = 0
    maxUcenik = None

    for ucenik in ucenici:
        ocene = ucenik['ocene']
        prosek = sum(ocene)/len(ocene)
        if (prosek>maxProsek):
            maxProsek = prosek
            maxUcenik = ucenik
    
    imePrezime = maxUcenik['ime'] + " " + maxUcenik['prezime']
    indeks = str(maxUcenik['indeks']) + "\\" + str(maxUcenik['godina'])

    return {
        'Ime i Prezime': imePrezime,
        'Indeks' : indeks,
        'Prosek' : maxProsek,
        'Grupa': filename.split('.')[0].split('\\')[1]
    }



folder = 'spiskovi'

najbolji = open("najbolji\\mika.csv", 'w', newline='')
polja = ['Ime i Prezime', 'Indeks', 'Prosek', 'Grupa']

writer = csv.DictWriter(najbolji, fieldnames=polja)
writer.writeheader()

for folderName, subfolders, filenames in os.walk(folder):
    for filename in filenames:
        if filename.endswith('.json'):
            writer.writerow(obradiOdeljenje(folder+"\\"+filename))

najbolji.close()