import bs4, os, csv

def obradiOdeljenje(filename):
    xml = open(filename)
    soup = bs4.BeautifulSoup(xml, features="html.parser")
    xml.close()

    ucenici = soup.select("student")

    maxProsek = 0
    maxUcenik = None

    for ucenik in ucenici:
        ocene = ucenik.select("ocena")
        oceneList = list()
        for ocena in ocene:
            oceneList.append(int(ocena.get_text()))
        
        prosek = sum(oceneList)/len(oceneList)
        if  prosek > maxProsek:
            maxProsek = prosek
            maxUcenik = ucenik
    

    imePrezime = maxUcenik.select('ime')[0].get_text()+" "+maxUcenik.select('prezime')[0].get_text()
    indeks = maxUcenik.get('indeks')+"\\"+maxUcenik.get('godina')

    return {
        'Ime i Prezime': imePrezime,
        'Indeks' : indeks,
        'Prosek' : maxProsek,
        'Grupa': filename.split('.')[0].split('\\')[1]
    }


folder = 'spiskovi'

najbolji = open("najbolji\\pera.csv", 'w', newline='')
polja = ['Ime i Prezime', 'Indeks', 'Prosek', 'Grupa']

writer = csv.DictWriter(najbolji, fieldnames=polja)
writer.writeheader()

for folderName, subfolders, filenames in os.walk(folder):
    for filename in filenames:
        if filename.endswith('.xml'):
            writer.writerow(obradiOdeljenje(folder+"\\"+filename))

najbolji.close()