import bs4,math,threading
from PIL import Image, ImageColor

def crtajKrug(centarX, centarY, r, width, height, ime):
    slika = Image.new('RGBA',(width,height), 'purple')
    for i in range(width):
        for j in range(height):
            if (math.sqrt((i-centarX)*(i-centarX)+(j-centarY)*(j-centarY))<r):
                slika.putpixel((i,j), ImageColor.getcolor('white','RGBA'))

    slika.save(ime+'.png')


def crtajPravougaonik(temeX, temeY, a, b, width, height, ime):
    slika = Image.new('RGBA',(width,height), 'purple')
    for i in range(width):
        for j in range(height):
            if (i>=temeX and i<=temeX+a and j>=temeY and j<=temeY+b):
                slika.putpixel((i,j), ImageColor.getcolor('white','RGBA'))

    slika.save(ime+'.png')


xml = open('objekti.xml')
soup = bs4.BeautifulSoup(xml, features="html.parser")

objekti = soup.select('objekat')

for objekat in objekti:
    tip = objekat.get('type')
    ime = objekat.get('ime')
    width, height = map(int,objekat.get('size').split())
    if (tip == 'pravougaonik'):
        a = int(objekat.select('a')[0].get_text())
        b = int(objekat.select('b')[0].get_text())
        temeX = int(objekat.select('x')[0].get_text())
        temeY = int(objekat.select('y')[0].get_text())
        nit = threading.Thread(target=crtajPravougaonik(temeX,temeY,a,b,width,height,ime))
        nit.start()
    if (tip == 'krug'):
        r = int(objekat.select('poluprecnik')[0].get_text())
        centarX = int(objekat.select('x')[0].get_text())
        centarY = int(objekat.select('y')[0].get_text())
        nit = threading.Thread(target=crtajKrug(centarX, centarY, r, width,height,ime))
        nit.start()
