#include <stdio.h>
#include <stdlib.h>

#define PASSAGE 1
#define WALL 0
#define PATH 2


#define UNDEFINED (-1)
#define EMPTY (-1)

#define TRUE 1
#define FALSE 0

typedef struct element {
	int cvor;
	struct element *sledeci;
} Element;

//dodavanje na red
void dodaj(Element **pocetak, Element **kraj, int i) {
	Element *temp;
	temp = (Element *)malloc(sizeof(Element));
	temp->cvor = i;
	temp->sledeci = NULL;
	if (*pocetak==NULL) {
		*pocetak = *kraj = temp;
	}
	else {
		(*kraj)->sledeci = temp;
		*kraj = temp;
	}
}

//skidanje sa reda
int skini(Element **pocetak, Element **kraj) {
	int cvor;
	Element *temp;
	if (*pocetak==NULL) {
		return EMPTY;
	}
	else {
		temp = *pocetak;
		*pocetak = temp->sledeci;
		cvor = temp->cvor;
		if (*kraj==temp) *kraj=NULL;
		free(temp);
		return cvor;
	}
}



// ------------------------


// TO DO PATH

void printPath(int **graf, int s, int v, int *preth, int n)
{
    int vi, vj;
    vi = v / n;
    vj = v % n;

    if (s == v)
    {
        // printf("%d ", s);
        graf[vi][vj] = PATH;
    }
    else if (preth[v] == UNDEFINED)
    {
        printf("Nema puta od %d do %d", s, v);
    }
    else
    {
        printPath(graf, s, preth[v], preth, n);
        // printf("%d ", v);
        graf[vi][vj] = PATH;
   
    }
}

void drawMaze(int **graf, int m, int n)
{
    int i, j;

    for (i = 0; i < m; i++)
    {
        for (j = 0; j < n; j++)
        {
            if (graf[i][j] == WALL)
                printf("*");
            else if(graf[i][j] == PATH)
                printf("#");
            else
                printf(" ");
        }
        printf("\n");
    }
}

int main(int argc, char const *argv[])
{
    
    int m, n;
    scanf("%d%d", &m, &n);

    int **graf;
    graf = (int **)malloc(m*sizeof(int *));
    int i, j;
    for( i = 0; i < m; i++)
    {
        graf[i] = (int *)malloc(n*sizeof(int));
    }

    // laod maze
    char c = getchar();
    int startI, startJ, endI, endJ;
    for( i = 0; i < m; i++)
    {
        for( j = 0; j < n; j++)
        {
            c = getchar();       
            if (c == '@') {
                graf[i][j] = WALL;
            }
            else
            {
                graf[i][j] = PASSAGE;
                
                if (c == '*') {
                    startI = i;
                    startJ = j;
                }else if (c == '#'){
                    endI = i;
                    endJ = j;
                }
            }
        }
        getchar();
    }

    printf("\n");
    drawMaze(graf, m, n);
    printf("\n");

    // BFS


    int *preth, *d;
    preth = (int *) malloc (n*m * sizeof(int));
    d = (int *) malloc (n*m * sizeof(int));

    for(i=0; i<n * m; i++)
    {
        preth[i] = UNDEFINED;
        d[i] = UNDEFINED;
    }

    // start je s
    int s = startI * n + startJ;
//    preth[s] = UNDEFINED;
    d[s] = 0; // s postao siv
    Element *pocetak, *kraj;
    pocetak = kraj = NULL;

    dodaj(&pocetak, &kraj, s);
    int u, v;
    int ui, uj;
    while((u = skini(&pocetak, &kraj)) != EMPTY )
    {
        ui = u / n;
        uj = u % n;

        // gore desno dole levo
        if(ui > 0 ) // gore
        {
            if(graf[ui - 1][uj] == PASSAGE)
            {
                v = (ui - 1) * n + uj;
                if(d[v] == UNDEFINED)
                {
                    d[v] = d[u] + 1;
					preth[v] = u;
					dodaj(&pocetak, &kraj, v);
                }
            }
        }
        if(uj + 1 < n) // desno
        {
            if(graf[ui][uj + 1] == PASSAGE)
            {
                v = ui * n + uj + 1;
                if(d[v] == UNDEFINED)
                {
                    d[v] = d[u] + 1;
					preth[v] = u;
					dodaj(&pocetak, &kraj, v);
                }
            }
        }
        if(ui + 1 < m)// dole
        {
            if(graf[ui + 1][uj] == PASSAGE)
            {
                v = (ui + 1) * n + uj;
                if(d[v] == UNDEFINED)
                {
                    d[v] = d[u] + 1;
					preth[v] = u;
					dodaj(&pocetak, &kraj, v);
                }
            }
        }
        if(uj > 0) // levo
        {
            if(graf[ui][uj - 1] == PASSAGE)
            {
                v = ui * n + uj - 1;
                if(d[v] == UNDEFINED)
                {
                    d[v] = d[u] + 1;
					preth[v] = u;
					dodaj(&pocetak, &kraj, v);
                }
            }
        }
    }

    int end = endI * n + endJ;


    printPath(graf, s, end, preth, n);

    printf("\n");
    drawMaze(graf, m, n);
    printf("\n");

    return 0;
}
