/*
shmget() - alocira segment deljene memorije
int shmget(key_t key, size_t size, int shmflg);
shmid=shmget(keyval,segsize,IPC_CREAT|0660))

shmctl() - operacije kontrole nad segmentom
int shmctl(int shmid, int cmd, struct shmid_ds *buf);
cmd - IPC_STAT, IPC_SET, IPC_RMID

shmat() - kaci memorijski segment u adresni prostor procesa
void *shmat(int shmid, const void *shmaddr, int shmflg);
shmat(shmid,0,0)

shmdt() - odvaja segment od adresnog prostora procesa
int shmdt(const void *shmaddr);
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#define SHM_SIZE 1024

int main(int argc, char *argv[])
{
    key_t key;
    int shmid;
    char *data;
    char poruka[SHM_SIZE];
    
    /* pravi kljuc */
    key = ftok("shmem1.c", 'R');
	printf("Kljuc je %d\n", key);

    /* povezuje se (i ako je moguce kreira) segment */
    shmid = shmget(key, SHM_SIZE, 0644 | IPC_CREAT);
    printf("ID segmenta je %d\n", shmid);

    /* prikaci segment da bi dobio pokazivac na njega */
    data = shmat(shmid, NULL, 0);

    /* citaj i stampaj segment */
    strcpy(poruka, data);
    printf("Primljena poruka: %s\n", poruka);

    /* odvaja se od segmenta */
    shmdt(data);

    return 0;
}


