<?php

	require_once "db.php";
	$db = new DB;
	
	$pisci = $db->getPisci();

	$failed = false;
	if (isset($_POST["login"])) {
		$user = $db->logIn($_POST["user"], $_POST["pass"]);
		if ($user) {
			session_start();
			$_SESSION["user_id"] = $user["id"];
			setcookie("ime", $user["ime"], time() + 86400 * 2, "/");
			if (isset($_POST["remember"])) {
				setcookie("prezime", $user["prezime"], time() + 86400 * 2, "/");
			} else {
				setcookie("prezime", "", time() - 1, "/");
			}
			header("Location: index.php");
		} else {
			$failed = true;
		}
	}
	
?>

<form method="post">
	Username:<br>
	<input type="text" name="user" id="user" value="<?php if (isset($_COOKIE["ime"])) echo $_COOKIE["ime"]; ?>" /><br>
	Password:<br>
	<input type="text" name="pass" id="pass" value="<?php if (isset($_COOKIE["prezime"])) echo $_COOKIE["prezime"]; ?>" /><br>
	Zapamti lozinku:
	<input type="checkbox" name="remember" />
	<input type="submit" name="login" />
</form>

<div style="color:red;">
	<?php
		if ($failed) {
			echo "Pogresan username / password<br><br>";
		}
	?>
</div>

<div id="radioButtons"></div>

<script>

	const $ = document.querySelector.bind(document);

	function izabranPisac(radio) {
		ime = radio.value.split(';')[0];
		prezime = radio.value.split(';')[1];
		$('#user').value = ime;
		$('#pass').value = prezime;
	}
	
	function formRadioButtons() {
		const div = $('#radioButtons');
		let x = new XMLHttpRequest();
		x.onreadystatechange = _ => {
			if (x.status == 200 && x.readyState == 4) {
				let pisci = JSON.parse(x.responseText);
				let content = '';
				pisci.forEach(pisac => {
					content += '<input type="radio" name="pisac" onclick="izabranPisac(this)" value="' + pisac.ime + ';' + pisac.prezime + '" />' + pisac.ime + ' ' + pisac.prezime + '<br>';
				});
				div.innerHTML = content;
			}
		}
		x.open('get', 'search.php?pisac=');
		x.send();
	}
	
	formRadioButtons();

</script>