<?php
	
	# DODAJ LOGOUT
	
	require_once "db.php";
	$db = new DB;
	
	session_start();	

	if (!isset($_SESSION["user_id"])) {
		header("Location: login.php");
	}
	
	if (isset($_GET["logout"])) {
		session_destroy();
		header("Location: login.php");
	}
	
	$isAdmin = false;
	
	$user = $db->getPisacById($_SESSION["user_id"]);
	if ($user["uloga"] == "admin") {
		$isAdmin = true;
	}
	
	$pisci = $db->getPisci();

?>

<style>
	td, th {
		padding: 10px;
	}
</style>

<h2><?php echo "Dobrodosli, ".$user["ime"]." ".$user["prezime"]."!"; ?></h2>

<h1>Pretraga biblioteke</h1>

<form>
	Pisac:
	<input type="text" name="pisac" onkeyup="pisacChanged()" id="pisac" />
	Knjiga:
	<input type="text" name="knjiga" onkeyup="knjigaChanged()" id="knjiga" />
</form>

<input type="hidden" name="admin" value="<?php echo $isAdmin ? 1 : 0 ?>" id="admin" />

<table border="1" id="tabela">

	<?php
		foreach($pisci as $pisac) {
			$knjige = $db->getKnjigeByPisacId($pisac["id"]);
			$c = 0;
			foreach($knjige as $knjiga) {
	?>
				<tr>
					<td><?php echo $knjiga["naslov"]; ?></td>
					<?php
						if ($c == 0) {
							$c++;
					?>
							<td rowspan="<?php echo count($knjige); ?>">
								<?php echo $pisac["ime"]." ".$pisac["prezime"]; ?>
							</td>
					<?php
							if ($isAdmin) {
					?>
								<td rowspan="<?php echo count($knjige); ?>"><button onclick="izbrisiPisca(<?php echo $pisac["id"]; ?>)">Izbrisi</button></td>
					<?php
							}
						}
					?>
				</tr>
	<?php
			}
		}
	?>

</table>

<br>

<a href="index.php?logout">Log out</a>

<script>

	const $ = document.querySelector.bind(document);
	const isAdmin = parseInt($('#admin').value);
	
	function updateTable(pisci) {
		const table = $('#tabela');
		let content = '';
		pisci.forEach(pisac => {
			pisac.knjige.forEach((knjiga, i) => {
				if (i) {
					content += '<tr><td>' + knjiga.naslov + '</td></tr>';
				} else {
					content += '<tr><td>' + knjiga.naslov + '</td><td rowspan="' + pisac.knjige.length + '">' + pisac.ime + ' ' + pisac.prezime + '</td>';
					if (isAdmin) {
						content += '<td rowspan="' + pisac.knjige.length +'"><button onclick="izbrisiPisca(' + pisac.id + ')">Izbrisi</button></td></tr>';
					} else {
						content += '</tr>';
					}
					
				}
			});
		});
		table.innerHTML = content;
	}
	
	function pisacChanged() {
		let pisacQuery = $('#pisac').value;
		let x = new XMLHttpRequest();
		x.onreadystatechange = _ => {
			if (x.status == 200 && x.readyState == 4) {
				let pisci = JSON.parse(x.responseText);
				updateTable(pisci);
			}
		}
		x.open('get', 'search.php?pisac=' + pisacQuery);
		x.send();
	}
	
	function knjigaChanged() {
		let knjigaQuery = $('#knjiga').value;
		let x = new XMLHttpRequest();
		x.onreadystatechange = _ => {
			if (x.status == 200 && x.readyState == 4) {
				let pisci = JSON.parse(x.responseText);
				updateTable(pisci);
			}
		}
		x.open('get', 'search.php?knjiga=' + knjigaQuery);
		x.send();
	}
	
	function izbrisiPisca(id) {
		let x = new XMLHttpRequest();
		x.onreadystatechange = _ => {
			if (x.status == 200 && x.readyState == 4) {
				let pisci = JSON.parse(x.responseText);
				updateTable(pisci);
			}
		}
		x.open('get', 'delete.php?pisac_id=' + id);
		x.send();
	}

</script>

