#include <iostream>
#include <boost/mpi.hpp>
#include <boost/mpi/communicator.hpp>
#include <boost/mpi/environment.hpp>
#include <boost/mpi/collectives.hpp>
#include <boost/serialization/access.hpp>
#include "stanovnici.h"
#include "drzava.h"
#include <vector>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>

double* Statistika(int godina,Drzava *drzave,int duzina)
{
    double *brSt;
    int i,j;

    brSt = (double*)malloc(6*sizeof(double));
    int brDrzava=0;
    for (i=1;i<7;i++)
    {
        brSt[i-1]=0;
        brDrzava=0;
        for(j=0;j<duzina;j++)
        {
            if (drzave[j].isNaKontinentu(i))
            {
                brSt[i-1]+=drzave[j].getBrStPoKm2(godina);
                brDrzava++;
            }
        }
        if (brDrzava!= 0) brSt[i-1] = brSt[i-1]/brDrzava;
    }

    return brSt;

}



using namespace std;
using namespace boost::mpi;

int main(int argc,char *argv[])
{
    environment env(argc,argv);
    communicator world;
    vector<Drzava> drzave;
    int i,j;
   FILE *f;
   char naziv[50];
   int idDrzave,idKontinenta,broj,god,brSt,brDrzava=0;
   double povrsina;

  // cout << "Moj id je "<<world.rank()<<endl;
   if (world.rank()==0)
   {
   f=fopen("drzave.dat","r");
   int uk;
   fscanf(f,"%d",&uk);
   while (uk>0)
   {
       fscanf(f,"%d%d%lf%d%s\n",&idDrzave,&idKontinenta,&povrsina,&broj,naziv);
      // cout <<idDrzave<<" "<<idKontinenta<< " "<<naziv<<endl;
       Drzava d;
       d.idDrzave=idDrzave;
       d.idKontinenta = idKontinenta;
       d.povrsina = povrsina;
       strcpy(d.naziv,naziv);

       for (i=0;i<broj;i++)
       {
           Stanovnici s;
           fscanf(f,"%d%d\n",&god,&brSt);
           s.godina=god;
           s.brojStanovnika=brSt;
           d.brojStanovnika.push_back(s);
       }

       drzave.push_back(d);
       brDrzava++;
    uk--;
   }
   fclose(f);
   }
//   cout <<"Ucitao sam i moj id je "<<world.rank() << endl;
   broadcast(world,brDrzava,0);
  // cout<< "Brdrzava je "<<brDrzava<<endl;
   int svakomPo = (int)(brDrzava/world.size());
  //   cout <<"Broadcast "<<endl;
   Drzava mojeDrzave[svakomPo];

   scatter(world,drzave,mojeDrzave,svakomPo,0);


   double  *prosek1951,*prosek2000;
   prosek1951 = (double*)malloc(6*sizeof(double));
   prosek2000 = (double*)malloc(6*sizeof(double));


prosek1951 = Statistika(1950,mojeDrzave,svakomPo);
prosek2000 = Statistika(2000,mojeDrzave,svakomPo);

double prosek1951Resenje[6],prosek2000Resenje[6];



reduce(world,prosek1951,6,prosek1951Resenje,plus<double>(),0);
reduce(world,prosek2000,6,prosek2000Resenje,plus<double>(),0);

/*
Mi smo na kolokvijumu govorili da se prosek racuna tako sto se zbirovi po kontinatima podele brojem procesa. Medjutim taj pristup nije dobar.
Ako se desi da neki proces nema ni jednu drzavu sa nekog kontitinanta  onda prosecna naseljenost ne moze da se dobije
deljem sa ukupnim brojem procesa
vec samo sa onim brojem procesa koji su ucestvovali u zbiru. Ovo moze da se resi tako sto se uvede na svakom procesu jos po jedan niz
koji ce da ima 1 ako postoje drzave sa kontinenta odnosno 0 u suprotnom. Potrebno je odraditi jos redukciju (zbir) tih nizova i  podeliti
odgovarajuce vrednosti nizova.

*/

if (world.rank()==0)
{
    for (i=0;i<6;i++)
     {
        cout << i+1 <<" 1950 - "<< prosek1951Resenje[i]/world.size()<< " ";
        cout << "2000 - " << prosek2000Resenje[i]/world.size()<<endl;
    }

}


}

