#ifndef DRZAVA_H
#define DRZAVA_H

#include <vector>
#include <iostream>
#include "stanovnici.h"
#include <boost/serialization/access.hpp>
#include <boost/serialization/vector.hpp>
using namespace std;

class Drzava
{
public:
    int idDrzave,idKontinenta;
    double povrsina;
   char naziv[50];
    //string naziv;
    vector<Stanovnici> brojStanovnika;

public:
    Drzava();
    void setPovrsina(double p)
    {
        this->povrsina=p;
    }
    double getPovrsina()
    {
        return this->povrsina;
    }
    double getBrStPoKm2(int godina);
    bool isNaKontinentu(int kont)
    {
        if (this->idKontinenta == kont) return true;
        else return false;
    }

    bool operator ==(const Drzava d)
    {
        if (d.idDrzave == this->idDrzave) return true;
        else return false;
    }

    friend class boost::serialization::access;
    template <class Archive>
    void serialize(Archive &ar,unsigned int verzija)
    {
        ar & this->idDrzave;
        ar & this->idKontinenta;
        ar & this->povrsina;
        ar &  this->brojStanovnika;
        ar & this->naziv;
    }

};

#endif // DRZAVA_H
