#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

#define koefA  10
#define koefB  15
#define dx 0.05
#define dy 0.05
#define dt 0.01
#define t 100
#define donja(id,b,n) (id*n/b)
#define gornja(id,b,n) (donja((id+1),b,n)-1)

typedef struct p
{
	int x,y;
	double k1,k2;
} Polje;

typedef struct maksimum
	{
		int x,y,tren;
		double konc;
	} Maks;


double ra,rb;

double pocetniA(int x,int y)
	{
		double x1 = x*dx;
		double y1 = y*dy;
		double a = 2-x1*x1-y1*y1;
		//printf("Pozvana sam za %d i %d, rez je %.2lf\n",x,y,a);
		if (a<0) return 0;
		return a;
	}
double pocetniB(int x,int y)
	{
		double x1 = x*dx;
		double y1 = y*dy;
		double a = 2-(5-x1)*(5-x1) - (5-y1)*(5-y1);
		//printf("Pozvana sam za %d i %d, rez je %.2lf\n",x,y,a);
		if (a<0) return 0;
		return a;
	}
double novo(double koef,double ja, double gore,double dole,double levo, double desno)
	{
		double rez;
		
		rez = koef*dy*dy*(dole+gore)+(1-2*koef*(dx*dx +dy*dy))*ja + koef*dx*dx*(levo+desno);
		if (rez <0) return 0;
//		printf("Vracam koncentraciju %lf jer : ja: %.2lf gore: %.2lf, dole: %.2lf,levo: %.2lf,desno: %.2lf\n",rez,ja,gore,dole,levo,desno);
		return rez;
	}

void maksKonc(Maks *m1,Maks *m2,int *len, MPI_Datatype *tip)
	{
		int i;
		
		for (i=0;i<*len;i++)
			{
				if (m1->konc >= m2->konc)
					{
						*m2=*m1;						
					}
				m2++;
				m1++;
			}
	}

int main(int argc,char *argv[])
	{
	
	int id,brojProcesa,i,j;
	MPI_Datatype struktura,kolona,strukZaMaks;
	int d,g;
	MPI_Status status;
	
	MPI_Init(&argc,&argv);
	MPI_Comm_size(MPI_COMM_WORLD,&brojProcesa);
	MPI_Comm_rank(MPI_COMM_WORLD,&id);
	
	int duzine[2]={2,2};
	MPI_Datatype stari[2] = {MPI_INT,MPI_DOUBLE};
	MPI_Aint pomak;
	MPI_Type_extent(MPI_INT,&pomak);
	MPI_Aint razmaci[2]={0,2*pomak};
	
	MPI_Type_struct(2,duzine,razmaci,stari,&struktura);
	MPI_Type_commit(&struktura);
	duzine[0]=3;
	duzine[1]=1;
	razmaci[0]=0;
	razmaci[1]=3*pomak;
	
	MPI_Type_struct(2,duzine,razmaci,stari,&strukZaMaks);
	MPI_Type_commit(&strukZaMaks);
	
	
	
	d= donja(id,brojProcesa,1000);
	g = gornja(id,brojProcesa,1000);
	//printf ("id = %d moja donja =%d i moja gornja %d\n",id,d,g);
	int brojKolona = g-d+1;
	
	int vrste=1000;
	int kolone = brojKolona+2;
	
	MPI_Type_vector(vrste,1,kolone,struktura,&kolona);
	MPI_Type_commit(&kolona);
	
	
	Polje *matrica;
	Polje *staramatrica;
	
	matrica = (Polje*)malloc(vrste*kolone*sizeof(Polje));
	staramatrica = (Polje*)malloc(vrste*kolone*sizeof(Polje));
	
	for (i=0;i<vrste;i++)
		for (j=1;j<kolone-1;j++) //zadnja kolona-2
			{
				matrica[i*kolone+ j].x=i;
				matrica[i*kolone+ j].y=d+j-1;
				matrica[i*kolone+j].k1 = pocetniA(i,d+j-1); // d+j je globalna
				matrica[i*kolone+j].k2 = pocetniB(i,d+j-1);
			}
		
	for (i=0;i<vrste;i++) 
		{
			matrica[i*kolone].k1=0;
			matrica[i*kolone + kolone-1].k1=0;
			matrica[i*kolone].k2=0;
			matrica[i*kolone+ kolone-1].k2=0;
		}
	/*for (i=0;i<vrste*kolone;i++)
		printf("%.2lf %.2lf\n ",matrica[i].k1,matrica[i].k2);*/
		
	int koraci = t;//dt;
	
		
		ra = koefA*dt*1.0/(dx*dy) ;
		rb = koefB*dt*1.0/(dx*dy);
		//printf("Koeficijenti %.2lf %.2lf\n",ra,rb); 
		Maks mojMaks;
		mojMaks.x=-1;
		mojMaks.y=-1;
		mojMaks.tren=-1;
		mojMaks.konc=0;
	while (koraci >0 )
		{
		if (id!= brojProcesa-1)
			{
				MPI_Send(&matrica[kolone-2],1,kolona,id+1,10,MPI_COMM_WORLD);		
			}
		if (id !=0)
			{
				MPI_Recv(&matrica[0],1,kolona,id-1,10,MPI_COMM_WORLD,&status);
				MPI_Send(&matrica[1],1,kolona,id-1,10,MPI_COMM_WORLD);		
			}
		if (id != brojProcesa-1)
			{
				MPI_Recv(&matrica[kolone-1],1,kolona,id+1,10,MPI_COMM_WORLD,&status);
			}
		
		for (i=0;i<vrste*kolone;i++)
			{
				staramatrica[i] = matrica[i];
				
			}
			
		
				
		for (i=0;i<vrste;i++)
			{
				for (j=1;j<kolone-1;j++) // sva moja polja
					{
						double gore,dole,levo,desno;
						
						if (i<vrste-1) gore = staramatrica[(i+1)*kolone+j].k1;
						else gore=0;
						if (i>0) dole = staramatrica[(i-1)*kolone+j].k1;
						else dole=0;
						matrica[i*kolone+j].k1 = novo(ra,staramatrica[i*kolone+j].k1,dole,gore,staramatrica[i*kolone+j-1].k1,staramatrica[i*kolone+j+1].k1);
						
						if (i<vrste-1) gore = staramatrica[(i+1)*kolone+j].k2;
						else gore=0;
						if (i>0) dole = staramatrica[(i-1)*kolone+j].k2;
						else dole=0;
						matrica[i*kolone+j].k2 = novo(rb,staramatrica[i*kolone+j].k2,dole,gore,staramatrica[i*kolone+j-1].k2,staramatrica[i*kolone+j+1].k2);
						
					}
			}
			
		for (i=0;i<vrste;i++)
			for (j=1;j<kolone-1;j++)
				{
					if (mojMaks.konc < (staramatrica[i*kolone+j].k1+staramatrica[i*kolone+j].k2)) // da bi se uhvatio pocetni trenutak
						{
							//printf("%d moja d=%d i moje g = %d Menjam maks...na poziciji %d %d sa vrednosti %.2lf na vrednost %.2lf\n",id,d,g,i,j,mojMaks.konc,staramatrica[i*kolone+j].k1+staramatrica[i*kolone+j].k2);
							mojMaks.x = i;
							mojMaks.y = d+j-1;
							mojMaks.tren = t-koraci;
							mojMaks.konc = staramatrica[i*kolone+j].k1+staramatrica[i*kolone+j].k2;
						}
				}
			//printf("proces %d maks je %.2lf u %d %d\n",id,mojMaks.konc,mojMaks.x,mojMaks.y);
			
			koraci --;
		}
	Maks resenje;
	
	MPI_Op najveci;
	MPI_Op_create((MPI_User_function*)maksKonc,1,&najveci);
	
	
	MPI_Reduce(&mojMaks,&resenje,1,strukZaMaks,najveci,0,MPI_COMM_WORLD);
	
	if (id==0)
		printf("tren %d koord %d %d i koncentracija %.2lf\n",resenje.tren,resenje.x,resenje.y,resenje.konc);
		
	
	MPI_Finalize();
	
	}
