import pygame as pg, pygamebg
import random

# otvaramo prozor
(sirina, visina) = (500,500)
prozor = pygamebg.open_window(sirina, visina, "Pomeranje jabuke")
# podešavamo događaje tastaturom - prvi događaj se generise nakon
# 10ms i svaki naredni nakon 10ms
pg.key.set_repeat(10,10)

# globalno stanje programa
jabuka = pg.image.load("jabuka.png")
jabuka_x = random.randint(0, sirina-jabuka.get_width())
jabuka_y = -jabuka.get_height()
korpa = pg.image.load("korpa.png")
korpa_x = 0
korpa_y = visina - korpa.get_height()
kraj = False

# crtanje scene
def crtaj(): # na ovom mestu se vrši crtanje
    prozor.fill(pg.Color("white"))
    prozor.blit(jabuka, (jabuka_x, jabuka_y))
    prozor.blit(korpa, (korpa_x, korpa_y))

# pomeranje jabuke
def pomeri_jabuku():
    global jabuka_y
    jabuka_y += 5

# da li je jabuka upala u korpu
def proveri_kraj():
    global kraj
    j_levo = jabuka_x
    j_desno = jabuka_x + jabuka.get_width()
    j_dole = jabuka_y + jabuka.get_height()
    k_levo = korpa_x
    k_desno = korpa_x + korpa.get_width()
    k_gore = visina - korpa.get_height()
    if (k_levo <= j_levo) and (k_desno >= j_desno) and (j_dole > k_gore):
        kraj = True
    
# obrada dogadjaja
def obradi_dogadjaj(dogadjaj):
    global kraj
    global korpa_x   # promenljive koje se mogu promeniti na osnovu nekog dogadjaja    
    if (dogadjaj.type == pg.KEYDOWN) and not(kraj):   # ako je u pitanju događaj tipa ???
        if dogadjaj.key == pg.K_LEFT:
            korpa_x -= 5        
        elif dogadjaj.key == pg.K_RIGHT:
            korpa_x += 5

def novi_frejm():
    if not(kraj):
        pomeri_jabuku()
        proveri_kraj()
        crtaj()
     
# započinjemo petlju obrade događaja
pygamebg.frame_loop(25, novi_frejm, obradi_dogadjaj)
