create procedure sp_novaProdaja(@sifraKnjige int, @brCKCitaoca int)
as
begin
	insert into prodaja(sifraKnjige,brCKCitaoca,vremeProdaje,obradjeno)
	values(@sifraKnjige, @brCKCitaoca, getdate(), 'ne')

	update knjige
	set stanje=stanje-1
	where sifra=@sifraKnjige
end
go

exec sp_novaProdaja 4, 3


create procedure sp_presek
as
begin
	declare @iznos decimal(10,2)
	
	select @iznos=sum(placeno)
	from
	(select (case when p.brCKCitaoca is null then k.cena else (1-c.popust)*k.cena end) as placeno
	from prodaja p join knjige k 
	on p.sifraKnjige=k.sifra
	left join citaoci c
	on p.brCKCitaoca=c.brClanskeKarte
	where obradjeno='ne') as prodajaPlacanje
	
	print 'Pazar je ' + convert(varchar(10),@iznos)

	update prodaja
	set obradjeno='da'
	where obradjeno='ne'

end
go

exec sp_presek


create procedure sp_brKupljenihKnjiga(@granica int)
as
begin
	select c.brClanskeKarte, c.ime, count(*)
	from prodaja p join citaoci c
	on p.brCKCitaoca = c.brClanskeKarte
	group by c.brClanskeKarte, c.ime
	having count(*)>=@granica
end
go

exec sp_brKupljenihKnjiga 2


create procedure sp_knjigeNajveciPopust
as
begin
	select k.naslov from
	prodaja p join knjige k
	on p.sifraKnjige=k.sifra
	where p.brCKCitaoca in
	(select top 1 brClanskeKarte 
	from citaoci
	order by popust desc)
end
go

exec sp_knjigeNajveciPopust


exec sp_novaProdaja 4, 3
exec sp_presek
exec sp_brKupljenihKnjiga 2
exec sp_knjigeNajveciPopust