use studentski_dom
go

create procedure sp_nova_rezervacija
(
	@id_studenta int,
	@datum_od date,
	@datum_do date
)
as
begin
	declare @zabrana varchar(10)
	select @zabrana=zabrana 
	from studenti
	where id=@id_studenta

	if @zabrana='ne'
	begin
		declare @odabrana_soba int
		select top 1 @odabrana_soba=s.br_sobe
		from sobe s
		where not exists (
			select r.soba
			from rezervacije r
			where s.br_sobe = r.soba and r.status<>'ponisteno'
			and
			( 
			(r.datum_od between @datum_od and @datum_do) or
			(r.datum_do between @datum_od and @datum_do) or
			(r.datum_od<=@datum_od and r.datum_do>=@datum_do)
			)
		)

		if @odabrana_soba is not null
		begin
			insert into rezervacije(soba, student, datum_od, datum_do, datum_rezervacije, status)
			values (@odabrana_soba, @id_studenta, @datum_od, @datum_do, getdate(), 'rezervisano')
		end
		else
		begin
			print 'Nema slobodnih soba za trazeno vreme.'
		end
	end
	else
	begin
		print 'Student nema pravo da rezervise sobu.'
	end
end
go


create procedure sp_potvrdjivanje
(
	@id_rezervacije int
)
as
begin
	declare @stat varchar(20)
	select @stat=status
	from rezervacije
	where id = @id_rezervacije

	if @stat<>'ponisteno'
	begin
		update rezervacije
		set status='potvrdjeno'
		where id = @id_rezervacije

		insert into placanja(rezervacija, vrsta_placanja, datum_placanja)
		values(@id_rezervacije, 'depozit', getdate())

	end
	else
	begin
		print 'Nazalost, vasa rezervacija je ponistena.'
	end
end
go


create procedure sp_placanje_kirije
(
	@id_rezervacije int
)
as
begin
	declare @stat varchar(20)
	select @stat=status
	from rezervacije
	where id = @id_rezervacije

	if @stat<>'ponisteno'
	begin
		insert into placanja(rezervacija, vrsta_placanja, datum_placanja) 
		values (@id_rezervacije, 'kirija', getdate())
	end
	else
	begin
		print 'Vasa rezervacija je ponistena, niste platili kiriju na vreme!'
	end
end
go


create procedure sp_ponistavanje_depozit
(
	@id_rezervacije int,
	@datum_rok date
)
as
begin
	declare @datum date, @stat varchar(20), @student int
	select @datum=datum_rezervacije, @stat=status, @student=student
	from rezervacije
	where id=@id_rezervacije
	
	if @datum <= @datum_rok and @stat='rezervisano'
	begin
		update rezervacije
		set status='ponisteno'
		where id=@id_rezervacije

		update studenti
		set zabrana='da'
		where id=@student
	end
end
go


create procedure sp_ponistavanje_kirija
(
	@id_rezervacije int,
	@mesec int,
	@godina int
)
as
begin
	declare @placeno int
	select @placeno=count(*)
	from placanja
	where rezervacija=@id_rezervacije
	and DATEPART(month, datum_placanja)=@mesec
	and DATEPART(year, datum_placanja)=@godina

	if @placeno=0
	begin
		update rezervacije
		set status='ponisteno'
		where id=@id_rezervacije

		print 'Student nije platio kiriju na vreme! Rezervacija se ponistava!'
	end
	else
	begin
		print 'Kirija je placena na vreme.'
	end
end
go
