use conference_host
go

create procedure sp_predaja
(
	@id_konf int,
	@naslov varchar(50),
	@link varchar(50),
	@autori varchar(100)
)
as
begin
	declare @status_pr varchar(20)
	select @status_pr=status_predaja 
	from konferencije
	where id=@id_konf

	if @status_pr='otvoreno'
	begin
		insert into radovi(redni_broj, id_konferencije, naslov_rada, link_do_rada, autori)
		values (null, @id_konf, @naslov, @link, @autori)
		print 'Uspesno poslat rad'
	end
	else
	begin
		print 'Prihvatanje radova zatvoreno, rad nije poslat na vreme.'
	end
end
go


create procedure sp_prihvatanje
(
	@id_rada int,
	@prihvacen varchar(10)
)
as
begin
	if @prihvacen='da'
	begin
		declare @id_konf int, @max_redni_broj int, @novi_redni_broj int
		
		select @id_konf=id_konferencije
		from radovi
		where id=@id_rada

		select @max_redni_broj=max(redni_broj)
		from radovi
		where id_konferencije=@id_konf

		if @max_redni_broj is null
			set @novi_redni_broj = 1
		else
			set @novi_redni_broj = @max_redni_broj+1

		update radovi
		set status_prihvacen='da', redni_broj=@novi_redni_broj
		where id=@id_rada
	end
	else
	begin
		update radovi
		set status_prihvacen='ne'
		where id=@id_rada
	end
end
go


create procedure sp_uplata
(
	@id_rada int,
	@id_konf int
)
as
begin
	declare @status_reg varchar(20)
	select @status_reg=status_registracija
	from konferencije
	where id = @id_konf

	if @status_reg='otvoreno'
	begin
		insert into uplate(id_rada, vreme_uplate)
		values(@id_rada, getdate())
		print 'Uspesno izvrsena uplata'
	end
	else
	begin
		print 'Registracija zatvorena, zakasnili ste sa uplatom.'
	end
end
go


create procedure sp_zatvaranje_predaje
(
	@id_konf int
)
as
begin
	update konferencije
	set status_predaja = 'zatvoreno'
	where id=@id_konf

	print 'Svi poslati radovi'
	select naslov_rada, autori from radovi
	where id_konferencije=@id_konf
end
go


create procedure sp_zatvaranje_registracije
(
	@id_konf int
)
as
begin
	update radovi
	set status_uplata='da'
	where status_prihvacen='da'
	and id in
	(
		select id_rada
		from uplate
	)

	update konferencije
	set status_registracija = 'zatvoreno'
	where id=@id_konf

	print 'Svi radovi koji ce biti prezentovani na konferenciji'

	select naslov_rada, autori from radovi
	where id_konferencije=@id_konf and status_uplata='da'
end
go