use online_igra
go

create procedure sp_novi_potez
(
	@idIgraca int, @idPartije int, @potez varchar(50), @brPoena int
)
as
begin
	declare @id int, @max_rbr int, @max_id int
	select @id = id
	from igrac_partija
	where idIgraca=@idIgraca
	and idPartije=@idPartije

	select @max_rbr = max(rbr_poteza_u_partiji)
	from potezi

	select @max_id = max(id)
	from potezi

	insert into potezi(id,idIgracPartija,potez,brDobijenihPoena,rbr_poteza_u_partiji)
	values(@max_id+1,@id,@potez,@brPoena,@max_rbr+1)
end
go

exec sp_novi_potez 23158, 30000, 'Novi potez', 3

create procedure sp_stanje_partije
(
	@idPartije int
)
as
begin
	select ip.idIgraca, sum(po.brDobijenihPoena) as poeni
	from potezi po join igrac_partija ip
	on po.idIgracPartija = ip.id
	where ip.idPartije = @idPartije
	group by ip.idIgraca
	order by poeni
end
go

exec sp_stanje_partije 100
go

create procedure sp_rang_lista
as
begin
	select top 50 i.id, i.username, count(*) as pobede
	from igraci i join igrac_partija ip
	on i.id = ip.idIgraca
	join partije par
	on ip.idPartije = par.id
	where i.id = par.pobednik
	group by i.id, i.username
	order by pobede desc
end
go

exec sp_rang_lista
go

create procedure sp_chat
(
	@idPartije int
)
as
begin
	select i.username, c.vremePoruke, c.tekstPoruke
	from chat c join igrac_partija ip
	on c.idIgracPartija = ip.id
	join igraci i
	on ip.idIgraca = i.id
	where ip.idPartije = @idPartije 
	order by c.vremePoruke
end
go

exec sp_chat 3000
go

create procedure sp_broj_igraca
as
begin
	select count(*)
	from igraci
end

exec sp_broj_igraca


exec sp_novi_potez 23158, 30000, 'Novi potez', 3
exec sp_stanje_partije 100
exec sp_rang_lista
exec sp_chat 3000
exec sp_broj_igraca