#include <stdio.h>
#include <stdlib.h>

#define INF (-1)
#define NILL (-1)
#define TRUE 1
#define FALSE 0

typedef struct {
    int p, t, minut;
} Veza;

typedef struct {
    int u;
    char PiliT;
} Cvor;

typedef struct {
    int sati;
    int minuti;
} Vreme;

Veza **graf;
Vreme *vremena;
Cvor *pret;
int n, m, polaziste, odrediste, *obidjen;

int jeManji(Vreme v1, Vreme v2) {

	if (v1.sati==INF)
		return FALSE;
	if (v2.sati==INF)
		return TRUE;
    if (v1.sati==v2.sati)
        return v1.minuti<v2.minuti;
	return v1.sati<v2.sati;
}

int nadjiMinimum() {
	int i;
	Vreme minVreme;
	minVreme.sati = minVreme.minuti = INF;
	int minCvor = NILL;
	for (i=1; i<=n; i++) {

		if (obidjen[i]==FALSE &&
           jeManji(vremena[i], minVreme)) {

			minVreme = vremena[i];
			minCvor = i;
		}
	}
	return minCvor;
}

void relax(int u, int v) {
    Vreme novoVreme = vremena[u];
    if (graf[u][v].p != INF) {
		novoVreme.minuti += graf[u][v].p;
        novoVreme.sati += novoVreme.minuti/60;
        novoVreme.minuti = novoVreme.minuti%60;
        if (jeManji(novoVreme, vremena[v])) {
            vremena[v] = novoVreme;
            pret[v].u = u;
            pret[v].PiliT = 'P';
        }
    }
    novoVreme = vremena[u];
    if (graf[u][v].t != INF) {
        if (graf[u][v].minut < vremena[u].minuti) {
            novoVreme.sati++;
        }
        novoVreme.minuti = graf[u][v].minut;

        novoVreme.minuti += graf[u][v].t;
        novoVreme.sati += novoVreme.minuti/60;
        novoVreme.minuti = novoVreme.minuti%60;
        if (jeManji(novoVreme, vremena[v])) {
            vremena[v] = novoVreme;
            pret[v].u = u;
            pret[v].PiliT = 'T';
        }
    }
}

void ispis(Cvor c) {
	if (c.u==polaziste) {
		//printf("%d %c %d %d\n", polaziste, c.PiliT, vremena[c.u].sati, vremena[c.u].minuti);
		printf("%d %c\n", polaziste, c.PiliT);
	}
	else if (pret[c.u].u == NILL) {
		printf("Nema puta od %d do %d.\n", polaziste, c.u);
	}
	else  {
		ispis(pret[c.u]);
		//printf("%d %c %d %d\n", c.u, c.PiliT, vremena[c.u].sati, vremena[c.u].minuti);
		printf("%d %c\n", c.u, c.PiliT);
	}
}

int main() {
	int i, j, u, v, p, t, minut;
	scanf("%d%d", &n, &m);

	graf = (Veza **)malloc((n+1)*sizeof(Veza *));
	vremena = (Vreme *)malloc((n+1)*sizeof(Vreme));
	pret = (Cvor *)malloc((n+1)*sizeof(Cvor));
	obidjen = (int *)malloc((n+1)*sizeof(int));

	for (i=1; i<=n; i++) {
		graf[i] = (Veza *)malloc(n*sizeof(Veza));
		vremena[i].sati = vremena[i].minuti = INF;
		pret[i].u = NILL;
		obidjen[i] = FALSE;
	}

	for (i=1; i<=n; i++)
		for (j=1; j<=n; j++)

                graf[i][j].p = graf[i][j].t =
                    graf[i][j].minut = INF;

	for (i=1; i<=m; i++) {
		scanf("%d%d%d%d%d", &u, &v, &p, &t, &minut);
		graf[u][v].p = p;
		graf[u][v].t = t;
		graf[u][v].minut = minut;
	}

	scanf("%d%d", &polaziste, &odrediste);
	vremena[polaziste].sati=12;
	vremena[polaziste].minuti=0;

	for (i=1; i<=n; i++) {
		u = nadjiMinimum();
		obidjen[u] = TRUE;
		for (j=1; j<=n; j++) {
			if (((graf[u][j].p!=INF)||(graf[u][j].t!=INF))
               && obidjen[j]==FALSE)
				relax(u, j);
		}
	}

	printf("%d %d\n", vremena[odrediste].sati, vremena[odrediste].minuti);
    ispis(pret[odrediste]);
    //printf("%d %d %d\n", odrediste, vremena[odrediste].sati, vremena[odrediste].minuti);
    printf("%d\n", odrediste);
	return 0;
}


