#include <stdio.h>
#include <stdlib.h>

#define INF (-1)
#define NILL (-1)
#define TRUE 1
#define FALSE 0

int *dV;

int jeManji(int i, int j) {
	if (i==INF)
		return FALSE;
	if (j==INF)
		return TRUE;
	return i<j;
}

int nadjiMinimum(int *obidjen, int *d, int n) {
	int i;
	int min = INF, minCvor=NILL;
	for (i=0; i<n; i++) {
		if (obidjen[i]==FALSE && jeManji(d[i], min)) {
			min = d[i];
			minCvor = i;
		}
	}
	return minCvor;
}

void relax(int **graf, int *d, int *pret, int u, int v) {
	if (jeManji(d[u]+graf[u][v], d[v])) {
		d[v] = d[u]+graf[u][v];
		pret[v] = u;
	}
}

void dijkstra(int **graf, int *obidjen, int *d, int *pret, int n, char KiliP)
{
	int u, i, v;
	while ((u = nadjiMinimum(obidjen, d, n))!=NILL) {
		obidjen[u] = TRUE;
		
		if (KiliP=='K' && !jeManji(d[u],dV[u])) {
			d[u] = INF;
		} 
		else {
			for (v=0; v<n; v++) {
				if (graf[u][v]!=INF && obidjen[v]==FALSE)
					relax(graf, d, pret, u, v);
			}
		}
	}
}


void ispis(int i, int polaziste, int *pret) {
	if (i==polaziste) {
		printf("%d\n", polaziste+1);
	}
	else if (pret[i]==NILL) {
		printf("Nema puta od %d do %d.\n", polaziste, i);
	}
	else  {
		ispis(pret[i], polaziste, pret);
		printf("%d\n", i+1);
	}
}

int main() {
	int **grafV, **grafP;
	int *dP, *pretV, *pretP, *obidjenV, *obidjenP;
	int n, m, a, b, c, d;
	int i, j, u, v, t;
	char KiliP;
	int minVreme;
	scanf("%d%d", &n, &m);
	
	grafV = (int **)malloc(n*sizeof(int *));
	grafP = (int **)malloc(n*sizeof(int *));
	dV = (int *)malloc(n*sizeof(int));
	dP = (int *)malloc(n*sizeof(int));
	pretV = (int *)malloc(n*sizeof(int));
	pretP = (int *)malloc(n*sizeof(int));
	obidjenV = (int *)malloc(n*sizeof(int));
	obidjenP = (int *)malloc(n*sizeof(int));
	
	for (i=0; i<n; i++) {
		grafV[i] = (int *)malloc(n*sizeof(int));
		grafP[i] = (int *)malloc(n*sizeof(int));
		dV[i] = INF;
		dP[i] = INF;
		pretV[i] = NILL;
		pretP[i] = NILL;
		obidjenV[i] = FALSE;
		obidjenP[i] = FALSE;
	}
	
	for (i=0; i<n; i++)
		for (j=0; j<n; j++) {
			grafV[i][j] = INF;
			grafP[i][j] = INF;
		}
	
	for (i=0; i<m; i++) {
		scanf("%d%d%d", &u, &v, &t);
		getchar();
		scanf("%c", &KiliP);
		u--; v--;
		if (KiliP=='K') {
			grafP[u][v] = t;
			grafP[v][u] = t;
		}
		if (KiliP=='P') {
			grafV[u][v] = t;
			grafV[v][u] = t;
		}
	}
	
	scanf("%d%d%d%d", &a, &b, &c, &d);
	a--; b--; c--; d--;
	dP[a] = 0;
	dV[c] = 0;
	
	dijkstra(grafV, obidjenV, dV, pretV, n, 'P');
	dijkstra(grafP, obidjenP, dP, pretP, n, 'K');
	
	if (dP[b]==INF)
		printf("ne moze\n");
	else {
		printf("moze\n");
		printf("%d\n", dP[b]);
		ispis(b, a, pretP);
	}
	
	return 0;
	
	/*
	printf("pretV\n");
	for (i=0; i<n; i++)
		printf("%d ", pretV[i]);
	printf("\n");
	
	printf("dP\n");
	for (i=0; i<n; i++)
		printf("%d ", dP[i]);
	printf("\n");
	* */
	
}

















