#include <stdio.h>
#include <stdlib.h>

#define SKUP_B 1
#define SKUP_N 0

int m, n; // m - broj jednacina (ogranicenja), n - broj promenljivih

double **a; // matrica koeficijenata
double *b; // slobodni clanovi ogranicenja
double *c; // koeficijenti ciljne funkcije
double *x; // vrednosti promenljivih
int *BN; // 0 - clan skupa N, skupa sporednih promenljivih
		 // 1 - clan skupa B, skupa osnovnih promenljivih

// Svi nizovi su dimenzije m+n zbog lakseg prevodjenja ulaznih
// promenljivih u izlazne prilikom pivotiranja.

double v; //slobodni clan u ciljnoj funkciji z


void UnesiPodatke() {
	int i, j;
	double fond;
	
	m = 6; // broj nejednacina
	n = 3; // broj nepoznatih
	
	a = (double **)malloc((n+m)*sizeof(double *));
	for (i=0; i<(n+m); i++)
		a[i] = (double *)malloc((n+m)*sizeof(double));
		
	for (i=0; i<(n+m); i++)
		for (j=0; j<(n+m); j++)
			a[i][j] = 0;
	
	b = (double *)malloc((n+m)*sizeof(double));
	c = (double *)malloc((n+m)*sizeof(double));
	x = (double *)malloc((n+m)*sizeof(double));
	BN = (int *)malloc((n+m)*sizeof(int));
	
	for (i=0; i<n; i++)
	{
		scanf("%lf", &c[i]);
		BN[i] = SKUP_N;
		b[i] = 0;
		a[n][i] = a[n+i+1][i] = c[i];
	}
	
	scanf("%lf", &fond);
	
	for (i=n; i<n+m; i++)
	{
		//scanf("%lf", &b[i]);
		BN[i] = SKUP_B;
		c[i] = 0;
	}
	
	b[n] = fond;
	b[n+1] = b[n+2] = b[n+3] = 40.0/100.0 * fond;
	b[n+4] = b[n+5] = 0;
		
	a[n+4][0] = a[n+5][1] = -1;
	a[n+4][1] = a[n+5][2] = 5;
	
	v = 0;

}


int nadjiUlaz() {
	int i;
	
	int e = -1;
	for (i=0; i<n+m; i++) {
		if (BN[i]==SKUP_N && c[i]>0) {
			e = i;
			break;
		}
	}
	return e;
}

int nadjiIzlaz(int e) {
	int l, i;
	double min;
	
	l = -1;
	
	for (i=0; i<m+n; i++) {
		if (BN[i]==SKUP_B && a[i][e]>0) { // ako je a[i][e]<=0, mozemo da povecavamo x[e] do beskonacnosti, a da ne prekoracimo ogranicenje
			if (l==-1) {
				min = b[i]/a[i][e];
				l = i;
			}
			else {
				if (b[i]/a[i][e] < min) {
					min = b[i]/a[i][e];
					l = i;
				}
			}
		}
	}
	
	return l;
}

void pivot(int e, int l) {
	int i,j;
	b[e] = b[l]/a[l][e];
	for (j=0; j<n+m; j++) {
		if (BN[j]==SKUP_N && j!=e) {
			a[e][j] = a[l][j]/a[l][e];
		}
	}
	a[e][l] = 1/a[l][e];
	
	for (i=0; i<n+m; i++) {
		if (BN[i]==SKUP_B && i!=l) {
			b[i] = b[i]-a[i][e]*b[e];
			for (j=0; j<m+n; j++) {
				if (BN[j]==SKUP_N && j!=e) {
					a[i][j] = a[i][j]-a[i][e]*a[e][j];
				}
			}
			a[i][l] = -a[i][e]*a[e][l];
		}
	}
	
	v = v + c[e]*b[e];
	for (j=0; j<m+n; j++) {
		if (BN[j]==SKUP_N && j!=e) {
			c[j] = c[j]-c[e]*a[e][j];
		}
	}
	c[l] = -c[e]*a[e][l];
	
	BN[e] = SKUP_B;
	BN[l] = SKUP_N;
}

main() {
	int e, l;
	int i, j;
	
	UnesiPodatke();
	
	while ( (e=nadjiUlaz())!=-1 ) {
		l = nadjiIzlaz(e);
		if (l==-1) {
			printf("Problem neogranicen.\n");
			break;
		}
		else {
			pivot(e,l);
		}
	}
	
	if (e==-1) {
		for (j=0; j<n; j++) {
			if (BN[j]==SKUP_B) {
				x[j] = b[j];
			}
			else {
				x[j] = 0;
			}
		}
		
		for (j=0; j<n; j++) {
			printf("%.2lf ", x[j]);
		}
		printf("\n%.2lf\n", v);
	}
	
}












