#include <stdio.h>
#include <stdlib.h>

#define INF -1

int manji(int a, int b) {
	if (a == INF) return 0;
	if (b == INF) return 1;
	return a<b;
}

int rekonstrukcija(int *pred, int i, int brPloca, int **ploce, int brPodstaze, int *zapr) {
	int ind;
	if (i==0) {
		ploce[brPodstaze] = (int *)malloc((brPloca+1)*sizeof(int));
		return 0;
	}
	else {
		ind = rekonstrukcija(pred, i-zapr[pred[i]], brPloca+1, ploce, brPodstaze, zapr);
		ploce[brPodstaze][++ind] = pred[i];
		return ind;
	}
	
}

int ranac(int *opt, int *pred, int n, int *zapr, int *vred, int m, int **ploce, int brPodstaze, int *brPlocaPoPodstazi) {
	int v,i;
	
	//Racunanje optimuma
	opt[0] = 0;
	pred[0] = 0;
	
	//Po zapreminama
	for (v=1; v<=n; v++) {	//Popunjavaju se sve zapremine v od 1 do n
		opt[v] = INF; pred[v] = 0;
		//Po predmetima
		for (i=1; i<=m; i++) {	//Proveravaju se svi predmeti i od 1 do m
			if (zapr[i]<=v && opt[v-zapr[i]]!=INF) {
				if (manji(vred[i]+opt[v-zapr[i]], opt[v])) {
					opt[v] = vred[i]+opt[v-zapr[i]];
					pred[v] = i;
				}
			}
		}
	}
	
	//Rekonstrukcija
	brPlocaPoPodstazi[brPodstaze] = rekonstrukcija(pred, n, 0, ploce, brPodstaze, zapr);
	
	return opt[n];
}

int main() {
	int *opt, *rek;
	int d, n, m;
	int *duzina, *cena;
	int *duzinaOcuvane, *udaljenost;
	int i, j, pozicija;
	int **ploce, *duzinePodstaza, *brPlocaPoPodstazi;
	int minCena = 0;
	
	//Unos duzine staze i broja tipova ploca
	scanf("%d%d",&d,&n);
	
	//Optimum i rekonstrukcija
	opt = (int *)malloc((d+1)*sizeof(int));
	rek = (int *)malloc((d+1)*sizeof(int));
	
	duzina = (int *)malloc((n+1)*sizeof(int));
	cena = (int *)malloc((n+1)*sizeof(int));
	
	//Unos duzina i cena
	for (i=1; i<=n; i++) {
		scanf("%d",&duzina[i]);
		scanf("%d",&cena[i]);
	}
	
	//Unos broja ocuvanih ploca
	scanf("%d",&m);
	
	ploce = (int **)malloc((m+1)*sizeof(int *));
	duzinePodstaza = (int *)malloc((m+1)*sizeof(int *));
	brPlocaPoPodstazi = (int *)malloc((m+1)*sizeof(int *));
	
	duzinaOcuvane = (int *)malloc((n+1)*sizeof(int));
	udaljenost = (int *)malloc((n+1)*sizeof(int));
	
	for (i=1; i<=m; i++) {
		scanf("%d",&duzinaOcuvane[i]);
		scanf("%d",&udaljenost[i]);
	}
		
	pozicija = 0;
	for (i=1; i<=m; i++) {
		duzinePodstaza[i-1] = udaljenost[i] - pozicija;
		minCena += ranac(opt, rek, duzinePodstaza[i-1], duzina,cena, n, ploce, i-1, brPlocaPoPodstazi);
		pozicija = udaljenost[i] + duzinaOcuvane[i];
	}	
	duzinePodstaza[m] = d - pozicija;
	minCena += ranac(opt, rek, duzinePodstaza[m], duzina,cena, n, ploce, m, brPlocaPoPodstazi);
	
	printf("%d\n", minCena);
	for (i=0; i<=m; i++) {
		if (brPlocaPoPodstazi[i]==0) {
			printf("-");
		}
		else {
			for (j=1; j<=brPlocaPoPodstazi[i]; j++) {
				printf("%d ", ploce[i][j]);
			}
		}
		printf("\n");
	}
	
	return 0;
	
}















