#include <stdio.h>
#include <stdlib.h>

#define SKUP_B 0
#define SKUP_N 1

double **A;
double *b, *c, *x, v;
int n, m;
int *NB;

void unesiPodatke() {
	int i, j;
	
	double kupMS, mesoMS, pirMS, kupPS, pirPS, kupP, mesoP;
	double kupU, mesoU, pirU, posuda;
	double cenaMS, cenaPS, cenaP;
	
	scanf("%lf%lf%lf", &kupMS, &mesoMS, &pirMS);
	scanf("%lf%lf", &kupPS, &pirPS);
	scanf("%lf%lf", &kupP, &mesoP);
	scanf("%lf%lf%lf%lf", &kupU, &mesoU, &pirU, &posuda);
	scanf("%lf%lf%lf", &cenaMS, &cenaPS, &cenaP);
	
	n = 3;
	m = 7;
	
	A = (double **)malloc((n+m+1)*sizeof(double *));
	for (i=1; i<=m+n; i++)
		A[i] = (double *)malloc((n+m+1)*sizeof(double));
		
	A[n+1][1]=kupMS/1000; A[n+1][2]=kupPS/1000; A[n+1][3]=kupP/1000;
	A[n+2][1]=mesoMS/1000; A[n+2][2]=0; A[n+2][3]=mesoP/1000;
	A[n+3][1]=pirMS/1000; A[n+3][2]=pirPS/1000; A[n+3][3]=0;
	A[n+4][1]=1; A[n+4][2]=0; A[n+4][3]=0;
	A[n+5][1]=0; A[n+5][2]=1; A[n+5][3]=0;
	A[n+6][1]=0; A[n+6][2]=0; A[n+6][3]=1;
	A[n+7][1]=-1; A[n+7][2]=-1; A[n+7][3]=1;
	
	b = (double *)malloc((n+m+1)*sizeof(double));
	c = (double *)malloc((n+m+1)*sizeof(double));
	x = (double *)malloc((n+m+1)*sizeof(double));
	NB = (int *)malloc((n+m+1)*sizeof(int));
	
	b[n+1]=kupU; b[n+2]=mesoU; b[n+3]=pirU;
	b[n+4]=b[n+5]=b[n+6]=posuda;
	b[n+7]=0;
	
	c[1]=cenaMS; c[2]=cenaPS; c[3]=cenaP;
	
	for (i=1; i<=n+m; i++) {
		if (i<=n) {
			NB[i] = SKUP_N;
			b[i] = 0.0;
		}
		else {
			NB[i] = SKUP_B;
			c[i] = 0.0;
		}
	}
	
	v = 0.0;
	
}


int nadjiUlaz() {
	int e = -1;
	int i;
	for (i=1; i<=n+m; i++) {
		if (NB[i]==SKUP_N) {
			if (c[i]>0) {
				e = i;
				break;
			}
		}
	}
	
	return e;
}

int nadjiIzlaz(int e) {
	int l = -1; 
	double min = -1;
	int i;
	
	for (i=1; i<=n+m; i++) {
		if (NB[i]==SKUP_B && A[i][e]>0) {
			if (min==-1 || (b[i]/A[i][e] < min)) {
				min = b[i]/A[i][e];
				l = i;
			}
		}
	}
	
	return l;
}

void pivot(int e, int l) {
	int i,j;
	b[e] = b[l]/A[l][e];
	A[e][l] = 1/A[l][e];
	
	for (j=1; j<=n+m; j++){
		if (NB[j]==SKUP_N && j!=e) {
			A[e][j] = A[l][j]/A[l][e];
		}
	}
	
	for (i=1; i<=n+m; i++) {
		if (NB[i]==SKUP_B && i!=l) {
			b[i] = b[i]-A[i][e]*b[e];
			
			for (j=1; j<=n+m; j++) {
				if (NB[j]==SKUP_N && j!=e) {
					A[i][j] = A[i][j]-A[i][e]*A[e][j];
				}
			}
			
			A[i][l] = -A[i][e]/A[l][e];
		}
	}
	
	for (j=1; j<=n+m; j++) {
		if (NB[j]==SKUP_N && j!=e) {
			c[j] = c[j] - c[e]*A[e][j];
		}
	}
	
	c[l] = -c[e]*A[e][l];
	
	v = v + c[e]*b[e];
	
	NB[e] = SKUP_B; NB[l] = SKUP_N;

}

int main() {
	int e, l, i, j;
	unesiPodatke();
	
	while ((e=nadjiUlaz()) != -1) {
		l = nadjiIzlaz(e);
        //printf("%d %d\n", e, l);
		if (l==-1) {
			printf("Neogranicen problem.\n");
			break;
		}
		else {
			pivot(e, l);
		}
	}
	
	if (e==-1) {
		printf("%.3lf\n", v);
		
		for (i=1; i<=n; i++) {
			if (NB[i]==SKUP_B) {
				x[i] = b[i];
			}
			else {
				x[i] = 0;
			}
			printf("%.3lf ", x[i]);
		}
		printf("\n");
		
		
	}
	
	return 0;
}





