#include <stdio.h>
#include <stdlib.h>

#define INF (-1000)
#define NILL (-1000)
#define TRUE 1
#define FALSE 0

void printArray(int *a, int n) {
	int i;
	for (i=1; i<=n; i++)
		printf("%d ", a[i]);
	printf("\n");
	
}

int jeManji(int i, int j) {
	if (i==INF)
		return FALSE;
	if (j==INF)
		return TRUE;
	return i<j;
}

int nadjiMinimum(int *obidjen, int *d, int n) {
	int i;
	int min = INF, minCvor=NILL;
	for (i=1; i<=n; i++) {
		if (obidjen[i]==FALSE && jeManji(d[i], min)) {
			min = d[i];
			minCvor = i;
		}
	}
	return minCvor;
}

void relax(int **graf, int *d, int *pret, int u, int v) {
	if (jeManji(d[u]+graf[u][v], d[v])) {
		d[v] = d[u]+graf[u][v];
		pret[v] = u;
	}
}

void dijkstra(int **graf, int **stanice, int *brStanica, int *obidjen, int *d, int m, int n)
{
	int u, i, j, v;
	for (i=1; i<=n; i++) {
		u = nadjiMinimum(obidjen, d, n);
		obidjen[u] = TRUE;
		for (v=1; v<=n; v++) {
			/*
			if (graf[u][v]!=INF && obidjen[v]==FALSE) {
				relax(graf, stanice, brStanica, d, pret, u, v);
			}
			*/
			
			if (graf[u][v]!=INF && d[v]==INF) {
				int linija = graf[u][v];
				for (j=1; j<=brStanica[linija]; j++) {
					if (d[stanice[linija][j]]==INF)
						d[stanice[linija][j]] = d[u]+1;
				}
			}
			
		}
		/*
		printf("Iteracija %d\n", i);
		printArray(d, n);
		*/
	}
}


int main() {
	int **graf, **stanice;
	int *d, *obidjen;
	int *brStanica;
	int n, m, pol, odr;
	int i, j, u, v, t;
	scanf("%d%d", &m, &n);

	graf = (int **)malloc((n+1)*sizeof(int *));
	stanice = (int **)malloc((m+1)*sizeof(int *));
	d = (int *)malloc((n+1)*sizeof(int));
	obidjen = (int *)malloc((n+1)*sizeof(int));
	brStanica = (int *)malloc((m+1)*sizeof(int));
	
	for (i=1; i<=m; i++) {
		scanf("%d", &brStanica[i]);
		stanice[i] = (int *)malloc((brStanica[i]+1)*sizeof(int));
	}
	
	for (i=1; i<=m; i++) {
		for (j=1; j<=brStanica[i]; j++) {
			scanf("%d", &stanice[i][j]);
		}
	}
	
	scanf("%d%d", &pol, &odr);
	
	for (i=1; i<=n; i++) {
		graf[i] = (int *)malloc((n+1)*sizeof(int));
		d[i] = INF;
		obidjen[i] = FALSE;
	}

	for (i=1; i<=n; i++)
		for (j=1; j<=n; j++)
			graf[i][j] = INF;

	
	for (i=1; i<=m; i++) {
		for (j=2; j<=brStanica[i]; j++) {
			u = stanice[i][j-1];
			v = stanice[i][j];
			graf[u][v] = graf[v][u] = i;
		}
	}
	
	d[pol] = -1;
	
	dijkstra(graf, stanice, brStanica, obidjen, d, m, n);
	
	
	printf("%d\n", d[odr]);
	
	return 0;
	
}

















