#include <stdio.h>
#include <stdlib.h>

#define SKUP_B 0
#define SKUP_N 1

double **A;
double *b, *c, *x, v;
int n, m;
int *NB;

void unesiPodatke() {
	int i, j;
	double kolZel, kolCrn, kolPap, cenaZel;
	double **proc;
	
	scanf("%lf%lf%lf", &kolZel, &kolCrn, &kolPap);
	
	m = 3; // broj nejednacina
	scanf("%d",&n); // broj mesavina
	
	proc = (double **)malloc((n+1)*sizeof(double *));
	for (i=1; i<=n; i++)
		proc[i] = (double *)malloc((m+1)*sizeof(double));
		
	for (i=1; i<=n; i++)
		for (j=1; j<=m; j++) {
			scanf("%lf", &proc[i][j]);
			proc[i][j] = proc[i][j]/100;
		}
	
	A = (double **)malloc((n+m+2)*sizeof(double *));
	for (i=1; i<=m+n+1; i++)
		A[i] = (double *)malloc((n+m+2)*sizeof(double));
		
	for (j=1; j<=n; j++) {
		A[n+1+1][j] = proc[j][1] + 2.0/3.0 * proc[j][3];
		A[n+1+2][j] = proc[j][2];
		A[n+1+3][j] = 1.0/3.0 * proc[j][3];
	}
	A[n+1+1][n+1] = 1; A[n+1+2][n+1] = 0; A[n+1+3][n+1] = 0;
	
	b = (double *)malloc((n+m+2)*sizeof(double));
	c = (double *)malloc((n+m+2)*sizeof(double));
	x = (double *)malloc((n+m+2)*sizeof(double));
	NB = (int *)malloc((n+m+2)*sizeof(int));
	
	for (i=1; i<=n+m+1; i++) {
		if (i<=n+1) {
			scanf("%lf", &c[i]);
			NB[i] = SKUP_N;
			b[i] = 0.0;
		}
		else {
			NB[i] = SKUP_B;
			c[i] = 0.0;
		}
	}
	
	b[n+1+1] = kolZel;
	b[n+1+2] = kolCrn;
	b[n+1+3] = kolPap;
	
	v = 0.0;
	
	n = n+1;
	
}


int nadjiUlaz() {
	int e = -1;
	int i;
	for (i=1; i<=n+m; i++) {
		if (NB[i]==SKUP_N) {
			if (c[i]>0) {
				e = i;
				break;
			}
		}
	}
	
	return e;
}

int nadjiIzlaz(int e) {
	int l = -1; 
	double min = -1;
	int i;
	
	for (i=1; i<=n+m; i++) {
		if (NB[i]==SKUP_B && A[i][e]>0) {
			if (min==-1 || (b[i]/A[i][e] < min)) {
				min = b[i]/A[i][e];
				l = i;
			}
		}
	}
	
	return l;
}

void pivot(int e, int l) {
	int i,j;
	b[e] = b[l]/A[l][e];
	A[e][l] = 1/A[l][e];
	
	for (j=1; j<=n+m; j++){
		if (NB[j]==SKUP_N && j!=e) {
			A[e][j] = A[l][j]/A[l][e];
		}
	}
	
	for (i=1; i<=n+m; i++) {
		if (NB[i]==SKUP_B && i!=l) {
			b[i] = b[i]-A[i][e]*b[e];
			
			for (j=1; j<=n+m; j++) {
				if (NB[j]==SKUP_N && j!=e) {
					A[i][j] = A[i][j]-A[i][e]*A[e][j];
				}
			}
			
			A[i][l] = -A[i][e]/A[l][e];
		}
	}
	
	for (j=1; j<=n+m; j++) {
		if (NB[j]==SKUP_N && j!=e) {
			c[j] = c[j] - c[e]*A[e][j];
		}
	}
	
	c[l] = -c[e]*A[e][l];
	
	v = v + c[e]*b[e];
	
	NB[e] = SKUP_B; NB[l] = SKUP_N;

}

int main() {
	int e, l, i, j;
	//printf("Pocinjem program\n");
	unesiPodatke();
	//printf("Uneo podatke\n");
	
	while ((e=nadjiUlaz()) != -1) {
		//printf("Nasao ulaz\n");
		l = nadjiIzlaz(e);
        //printf("%d %d\n", e, l);
		if (l==-1) {
			printf("Neogranicen problem.\n");
			break;
		}
		else {
			pivot(e, l);
		}
	}
	
	if (e==-1) {
		printf("%.3lf\n", v);
		for (i=1; i<=n; i++) {
			if (NB[i]==SKUP_B) {
				x[i] = b[i];
			}
			else {
				x[i] = 0;
			}
			if (i==n) printf("\n");
			printf("%.3lf ", x[i]);
		}

	}
	
	return 0;
}





