#include <stdio.h>
#include <stdlib.h>

#define INF (-1)
#define NILL (-1)
#define TRUE 1
#define FALSE 0

void printArray(int *a, int n) {
	int i;
	for (i=1; i<=n; i++) {
		printf("%d ",a[i]);
	}
	printf("\n");
}

void printSquareMatrix(int **a, int n) {
	int i, j;
	for (i=1; i<=n; i++) {
		for (j=1; j<=n; j++) {
			printf("%d ", a[i][j]);
		}
		printf("\n");
	}
}


int jeManji(int i, int j) {
	if (i==INF)
		return FALSE;
	if (j==INF)
		return TRUE;
	return i<j;
}

int nadjiMinimum(int *obidjen, int *d, int n) {
	int i;
	int min = INF, minCvor=NILL;
	for (i=1; i<=n; i++) {
		if (obidjen[i]==FALSE && jeManji(d[i], min)) {
			min = d[i];
			minCvor = i;
		}
	}
	return minCvor;
}

void relax(int **graf, int *d, int *pret, int u, int v) {
	if (jeManji(d[u]+graf[u][v], d[v])) {
		d[v] = d[u]+graf[u][v];
		pret[v] = u;
	}
}

void dijkstra(int **graf, int *obidjen, int *d, int *pret, int n)
{
	int u, i, v;
	for (i=1; i<=n; i++) {
		u = nadjiMinimum(obidjen, d, n);
		obidjen[u] = TRUE;
		for (v=1; v<=n; v++) {
			if (graf[u][v]!=INF && obidjen[v]==FALSE)
				relax(graf, d, pret, u, v);
		}
	}
}

void ispis(int i, int polaziste, int *pret, int n) {
	if (i==polaziste) {
		printf("%d ", polaziste);
	}
	else if (i==n) {
		ispis(pret[i], polaziste, pret, n);
	}
	else  {
		ispis(pret[i], polaziste, pret, n);
		printf("%d ", i);
	}
}

void ispisKontra(int i, int polaziste, int *pret) {
	if (i==polaziste) {
		printf("%d ", polaziste);
	}
	else  {
		printf("%d ", i);
		ispisKontra(pret[i], polaziste, pret);
	}
}

int main() {
	int **graf;
	int *rastojanjaPol, *rastojanjaOdr;
	int *pretPol, *pretOdr;
	int brRas, brVez, pol, odr, rez, potr;
	int *obidjenPol, *obidjenOdr;
	int i, j, u, v, w, wPuta, n, m, pumpa;
	
	scanf("%d%d", &rez, &potr);
	scanf("%d%d", &brRas, &brVez);
	n = brRas+1; // predstaviti i pumpu kao cvor
	m = brVez;

	graf = (int **)malloc((n+1)*sizeof(int *));
	rastojanjaPol = (int *)malloc((n+1)*sizeof(int));
	rastojanjaOdr = (int *)malloc((n+1)*sizeof(int));
	pretPol = (int *)malloc((n+1)*sizeof(int));
	pretOdr = (int *)malloc((n+1)*sizeof(int));
	obidjenPol = (int *)malloc((n+1)*sizeof(int));
	obidjenOdr = (int *)malloc((n+1)*sizeof(int));

	for (i=1; i<=n; i++) {
		graf[i] = (int *)malloc((n+1)*sizeof(int));
		rastojanjaPol[i] = INF;
		rastojanjaOdr[i] = INF;
		pretPol[i] = NILL;
		pretOdr[i] = NILL;
		obidjenPol[i] = FALSE;
		obidjenOdr[i] = FALSE;
	}
	for (i=1; i<=n; i++)
		for (j=1; j<=n; j++)
                graf[i][j] = graf[j][i] = INF;

	for (i=1; i<=m; i++) {
		scanf("%d%d%d", &u, &v, &w);
		graf[u][v] = graf[v][u] = w*potr;	// tezina - koliko se goriva potrosi
	}
	
	// pumpa
	scanf("%d%d%d", &u, &v, &w);
	
	//wPuta = graf[u][v];
	//printf("Pumpa\ngraf[u][v] : %d\n", graf[u][v]);
	graf[u][n] = graf[n][u] = w*potr;
	graf[n][v] = graf[v][n] = graf[u][v]-graf[u][n];
	graf[u][v] = graf[v][u] = INF;
	
	//printf("\n");
	//printSquareMatrix(graf, n);

	scanf("%d%d", &pol, &odr);
	
	rastojanjaPol[pol] = 0;
	rastojanjaOdr[odr] = 0;

	dijkstra(graf, obidjenPol, rastojanjaPol, pretPol, n);
	dijkstra(graf, obidjenOdr, rastojanjaOdr, pretOdr, n);
	
	//printf("rastojanja od polazista:\n");
	//printArray(rastojanjaPol,n);
	
	pumpa = n;
	if (rastojanjaPol[odr] <= rez) {
		printf("%d\n", rastojanjaPol[odr] / potr);
		ispis(odr, pol, pretPol, n);
		printf("\n");
	}
	else if (rastojanjaPol[pumpa] <= rez && rastojanjaOdr[pumpa] <= rez){
		printf("%d\n", (rastojanjaPol[pumpa] + rastojanjaOdr[pumpa]) / potr);
		ispis(pumpa, pol, pretPol, n);
		ispisKontra(pretOdr[pumpa], odr, pretOdr);
	}
	else {
		printf("-1\n");
	}

	return 0;
}


