#include <stdio.h>
#include <stdlib.h>

#define INF (-1)
#define NILL (-1)
#define TRUE 1
#define FALSE 0

int jeManji(double i, double j) {
	if (i==INF)
		return FALSE;
	if (j==INF)
		return TRUE;
	return i<j;
}

int nadjiMinimum(int *obidjen, double *d, int n) {
	int i;
	double min = INF;
    int minCvor=NILL;
	for (i=0; i<n; i++) {
		if (obidjen[i]==FALSE && jeManji(d[i], min)) {
			min = d[i];
			minCvor = i;
		}
	}
	return minCvor;
}

void relax(double **graf, double *d, int *pret, int u, int v, double **grafKm, double *dKm) {
	if (jeManji(d[u]+graf[u][v], d[v])) {
		d[v] = d[u]+graf[u][v];
		pret[v] = u;

        dKm[v] = dKm[u]+grafKm[u][v];
        //printf("%lf \n", dKm[u]);
	}
}

void dijkstra(double **graf, int *obidjen, double *d, int *pret, int n, double **grafKm, double *dKm )
{
	int u, i, v;
	while ((u = nadjiMinimum(obidjen, d, n)) != NILL) {
		obidjen[u] = TRUE;
		for (v=0; v<n; v++) {
			if (graf[u][v]!=INF && obidjen[v]==FALSE)
				relax(graf, d, pret, u, v, grafKm, dKm);
		}
	}
}


void rekonstrukcija(int i, int polaziste, int *pret, int stampajPolaziste) {
	int rbr;
	if (i==polaziste) 
    {
        if(stampajPolaziste)
		{
            printf("%d ", polaziste);
        }
        return;
	}
	else  {
		rekonstrukcija(pret[i], polaziste, pret, stampajPolaziste);
        printf("%d ", i);
	}
}

void rekonstrukcija_izbaci(int i, int polaziste, int *pret, int *uvrsteni) {
	int rbr;
	if (i==polaziste) 
    {
        return;
	}
	else  {
        uvrsteni[i] = TRUE;
		rekonstrukcija_izbaci(pret[i], polaziste, pret, uvrsteni);
	}
}

int main() {
	double **graf;
    double **grafKm;
    
	double *dKaCilju, *dKaKuci;
    double *dKaCiljuKm, *dKaKuciKm;

	int i, j, u, v, n, m, *izbaciCvor, *pretKaCilju, *pretKaKuci, *obidjenKaCilju, *obidjenKaKuci;
    double l, w;
    double cenaGoriva, potrosnjaAutoput, potrosnjaRegionalni;
    scanf("%lf%lf%lf", &cenaGoriva, &potrosnjaAutoput, &potrosnjaRegionalni);
	double rbrLokacije, vremeHapsenja;
	scanf("%d%d", &n, &m);

	graf = (double **)malloc(n*sizeof(double *));
    grafKm = (double **)malloc(n*sizeof(double *));
    
	dKaCilju = (double *)malloc(n*sizeof(double));
	dKaKuci = (double *)malloc(n*sizeof(double));
    dKaCiljuKm = (double *)malloc(n*sizeof(double));
	dKaKuciKm = (double *)malloc(n*sizeof(double));
    
	pretKaCilju = (int *)malloc(n*sizeof(int));
	pretKaKuci = (int *)malloc(n*sizeof(int));
	obidjenKaCilju = (int *)malloc(n*sizeof(int));
	obidjenKaKuci = (int *)malloc(n*sizeof(int));
	izbaciCvor = (int *)malloc(n*sizeof(int));

	for (i=0; i<n; i++) {
		graf[i] = (double *)malloc(n*sizeof(double));
        grafKm[i] = (double *)malloc(n*sizeof(double));
        
		dKaCilju[i] = INF;
		dKaKuci[i] = INF;
        
        dKaCiljuKm[i] = INF;
		dKaKuciKm[i] = INF;
     

		pretKaCilju[i] = NILL;
		pretKaKuci[i] = NILL;

		obidjenKaCilju[i] = FALSE;
		obidjenKaKuci[i] = FALSE;
        izbaciCvor[i] = FALSE;
	}

	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
        {
			graf[i][j] = INF;
            grafKm[i][j] = INF;
        }
    int jeAutoput;    
    double putarina;    
	for (i=0; i<m; i++) {
		scanf("%d%d%lf%d", &u, &v, &l, &jeAutoput);
        if(jeAutoput)
        {
            scanf("%lf", &putarina);
            w = l / 100.0 * potrosnjaAutoput * cenaGoriva + putarina;
        }
        else{

            w = l / 100.0 * potrosnjaRegionalni * cenaGoriva;
        }
        if(jeManji(w, graf[u][v]))
        {
            graf[u][v] = w;
            graf[v][u] = w;

            grafKm[u][v] = l;
            grafKm[v][u] = l;

        }
        
	}

    int polaziste, odrediste;
	scanf("%d%d", &polaziste, &odrediste);
	dKaCilju[polaziste] = 0;
    dKaCiljuKm[polaziste] = 0;

	dijkstra(graf, obidjenKaCilju, dKaCilju, pretKaCilju, n, grafKm, dKaCiljuKm);
    if(dKaCilju[odrediste] == INF)
    {
        printf("-1\n");
        return 0;
    }


	rekonstrukcija_izbaci(odrediste, polaziste, pretKaCilju, izbaciCvor);
    for(i=0; i<n; i++)
    {
        if(i!=odrediste && izbaciCvor[i])
        {
            // printf("i: %d\n", i);
            for(j=0; j<n; j++)
            {
                graf[i][j] = INF;
                graf[j][i] = INF;
                
                grafKm[i][j] = INF;
                grafKm[j][i] = INF;
                
            }
        }
    }

	dKaKuci[odrediste] = 0;
    dKaKuciKm[odrediste] = 0;
   


	dijkstra(graf, obidjenKaKuci, dKaKuci, pretKaKuci, n, grafKm, dKaKuciKm);
    if(dKaKuci[polaziste] == INF)
    {
        printf("-1\n");
        return 0;
    }

    printf("%.4lf\n", dKaCilju[odrediste] + dKaKuci[polaziste]);
    printf("%.4lf\n", dKaCiljuKm[odrediste] + dKaKuciKm[polaziste]);
    	
    rekonstrukcija(odrediste, polaziste, pretKaCilju, TRUE);
    rekonstrukcija(polaziste, odrediste, pretKaKuci, FALSE);
    printf("\n");
	return 0;

}

















