#include <stdio.h>
#include <stdlib.h>

#define SKUP_B 1
#define SKUP_N 0

int m, n; // m - broj jednacina (ogranicenja), n - broj promenljivih

double **a; // matrica koeficijenata
double *b; // slobodni clanovi ogranicenja
double *c; // koeficijenti ciljne funkcije
double *x; // vrednosti promenljivih
int *BN; // 0 - clan skupa N, skupa sporednih promenljivih
		 // 1 - clan skupa B, skupa osnovnih promenljivih

// Svi nizovi su dimenzije m+n zbog lakseg prevodjenja ulaznih
// promenljiva u izlazne prilikom pivotiranja.

double v; //slobodni clan u ciljnoj funkciji z


void UnesiPodatke() {
	int i, j;
	
	m = 5; // broj nejednacina
	n = 4; // broj nepoznatih
	
	a = (double **)malloc((n+m)*sizeof(double *));
	for (i=0; i<(n+m); i++)
		a[i] = (double *)malloc((n+m)*sizeof(double));
	
	b = (double *)malloc((n+m)*sizeof(double));
	c = (double *)malloc((n+m)*sizeof(double));
	x = (double *)malloc((n+m)*sizeof(double));
	BN = (int *)malloc((n+m)*sizeof(int));
	


	double dzem1Sljiva, dzem1Kajsija, dzem1Visnja, dzem1Secer;
	double dzem2Sljiva, dzem2Kajsija, dzem2Visnja = 0, dzem2Secer;
	double dzem3Sljiva, dzem3Kajsija = 0, dzem3Visnja, dzem3Secer;
	double dzem4Sljiva = 0, dzem4Kajsija, dzem4Visnja, dzem4Secer;
	
	scanf("%lf%lf%lf%lf", &dzem1Sljiva, &dzem1Kajsija, &dzem1Visnja, &dzem1Secer);
	scanf("%lf%lf%lf", &dzem2Sljiva, &dzem2Kajsija, &dzem2Secer);
	scanf("%lf%lf%lf", &dzem3Sljiva, &dzem3Visnja, &dzem3Secer);
	scanf("%lf%lf%lf", &dzem4Kajsija, &dzem4Visnja, &dzem4Secer);


	// ucitava koilicine resursa
	double secer, sljiva, visnja, kajsija;
	scanf("%lf%lf%lf%lf", &secer, &sljiva, &visnja, &kajsija);
	b[n] = secer;
	b[n+1] = sljiva;
	b[n+2] = visnja;
	b[n+3] = kajsija;
	
	for (i=n; i<n+m; i++)
	{
		BN[i] = SKUP_B;
		c[i] = 0;
	}
	// cene
	for (i=0; i<n; i++)
	{
		scanf("%lf", &c[i]);
		BN[i] = SKUP_N;
		b[i] = 0;
	}
	
	double budzet;
	scanf("%lf", &budzet);
	b[n+4] = budzet;
	double trosak1, trosak2, trosak3, trosak4;
	scanf("%lf%lf%lf%lf", &trosak1, &trosak2, &trosak3, &trosak4);
	c[0] = c[0] - trosak1;
	c[1] = c[1] - trosak2;
	c[2] = c[2] - trosak3;
	c[3] = c[3] - trosak4;
	
	//--------------------------------------------


	
	// secer
	a[n][0] = dzem1Secer;
	a[n][1] = dzem2Secer;
	a[n][2] = dzem3Secer;
	a[n][3] = dzem4Secer;
	
	// sljiva
	a[n+1][0] = dzem1Sljiva;
	a[n+1][1] = dzem2Sljiva;
	a[n+1][2] = dzem3Sljiva;
	a[n+1][3] = dzem4Sljiva;
	
	// Kajsija
	a[n+2][0] = dzem1Kajsija;
	a[n+2][1] = dzem2Kajsija;
	a[n+2][2] = dzem3Kajsija;
	a[n+2][3] = dzem4Kajsija;
	// visnja
	a[n+3][0] = dzem1Visnja;
	a[n+3][1] = dzem2Visnja;
	a[n+3][2] = dzem3Visnja;
	a[n+3][3] = dzem4Visnja;
	// budzet
	a[n+4][0] = trosak1;
	a[n+4][1] = trosak2;
	a[n+4][2] = trosak3;
	a[n+4][3] = trosak4;

	// for(i = n; i<=n+4; i++)
	// {
	// 	printf("%2lf  %2lf  %2lf  %2lf\n", a[i][0], a[i][1],a[i][2],a[i][3] );
	// }

	
	v = 0;

}


int nadjiUlaz() {
	int i;
	
	int e = -1;
	for (i=0; i<n+m; i++) {
		if (BN[i]==SKUP_N && c[i]>0) {
			e = i;
			break;
		}
	}
	return e;
}

int nadjiIzlaz(int e) {
	int l, i;
	double min;
	
	l = -1;
	
	for (i=0; i<m+n; i++) {
		if (BN[i]==SKUP_B && a[i][e]>0) {
			if (l==-1) {
				min = b[i]/a[i][e];
				l = i;
			}
			else {
				if (b[i]/a[i][e] < min) {
					min = b[i]/a[i][e];
					l = i;
				}
			}
		}
	}
	
	return l;
}

void pivot(int e, int l) {
	int i,j;
	b[e] = b[l]/a[l][e];
	for (j=0; j<n+m; j++) {
		if (BN[j]==SKUP_N && j!=e) {
			a[e][j] = a[l][j]/a[l][e];
		}
	}
	a[e][l] = 1/a[l][e];
	
	for (i=0; i<n+m; i++) {
		if (BN[i]==SKUP_B && i!=l) {
			b[i] = b[i]-a[i][e]*b[e];
			for (j=0; j<m+n; j++) {
				if (BN[j]==SKUP_N && j!=e) {
					a[i][j] = a[i][j]-a[i][e]*a[e][j];
				}
			}
			a[i][l] = -a[i][e]*a[e][l];
		}
	}
	
	v = v + c[e]*b[e];
	for (j=0; j<m+n; j++) {
		if (BN[j]==SKUP_N && j!=e) {
			c[j] = c[j]-c[e]*a[e][j];
		}
	}
	c[l] = -c[e]*a[e][l];
	
	BN[e] = SKUP_B;
	BN[l] = SKUP_N;
}

int main() {
	int e, l;
	int i, j;
	
	UnesiPodatke();
	
	while ( (e=nadjiUlaz())!=-1 ) {
		l = nadjiIzlaz(e);
		if (l==-1) {
			printf("Problem neogranicen.\n");
			break;
		}
		else {
			pivot(e,l);
		}
	}
	
	if (e==-1) 
	{
		printf("%.2lf\n", v);
		for (j=0; j<n; j++) {
			if (BN[j]==SKUP_B) {
				x[j] = b[j];
			}
			else {
				x[j] = 0;
			}
		}
		
		for (j=0; j<n; j++) {
			printf("%.2lf ", x[j]);
		}
	}
	printf("\n");

	return 0;	
}












