#include <stdio.h>
#include <stdlib.h>

#define SKUP_B 1
#define SKUP_N 0

int m, n; // m - broj jednacina (ogranicenja), n - broj promenljivih

double **a; // matrica koeficijenata
double *b; // slobodni clanovi ogranicenja
double *c; // koeficijenti ciljne funkcije
double *x; // vrednosti promenljivih
int *BN; // 0 - clan skupa N, skupa sporednih promenljivih
		 // 1 - clan skupa B, skupa osnovnih promenljivih

// Svi nizovi su dimenzije m+n zbog lakseg prevodjenja ulaznih
// promenljiva u izlazne prilikom pivotiranja.

double v; //slobodni clan u ciljnoj funkciji z

double Du, PK, Dsto, Tsto, Dstolica, Tstolica;
double Kgradja, Kproizvodi, Cgradja, Csto, Cstolica;

int stoloviKomada, stoliceKomada;
double zarada, gradjaTona;


void UnesiPodatke() {
	int i;

	m = 4; // broj nejednacina
	n = 3; // broj nepoznatih

	a = (double **)malloc((n+m)*sizeof(double *));
	for (i=0; i<(n+m); i++)
		a[i] = (double *)malloc((n+m)*sizeof(double));

	b = (double *)malloc((n+m)*sizeof(double));
	c = (double *)malloc((n+m)*sizeof(double));
	x = (double *)malloc((n+m)*sizeof(double));
	BN = (int *)malloc((n+m)*sizeof(int));

	for (i=0; i<n; i++)
	{
		//scanf("%lf", &c[i]);
		BN[i] = SKUP_N;
		b[i] = 0;
	}

	for (i=n; i<n+m; i++)
	{
		//scanf("%lf", &b[i]);
		BN[i] = SKUP_B;
		c[i] = 0;
	}

    scanf("%lf%lf", &Du, &PK);
    scanf("%lf%lf", &Dsto, &Tsto);
    scanf("%lf%lf", &Dstolica, &Tstolica);
    scanf("%lf%lf", &Kgradja, &Kproizvodi);
    scanf("%lf%lf%lf", &Cgradja, &Csto, &Cstolica);
    Dsto /= 1000; Dstolica /= 1000;

    a[n][0]  =Dsto;     a[n][1]  =Dstolica; a[n][2]=1;
    a[n+1][0]=Tsto;     a[n+1][1]=Tstolica; a[n+1][2]=0;
    a[n+2][0]=Dsto;     a[n+2][1]=Dstolica; a[n+2][2]=0;
    a[n+3][0]=0;        a[n+3][1]=0;        a[n+3][2]=1;

    b[n]=Du;
    b[n+1]=PK;
    b[n+2]=Kproizvodi;
    b[n+3]=Kgradja;

	c[0]=Csto; c[1]=Cstolica; c[2]=Cgradja;

	v = 0;

}


int nadjiUlaz() {
	int i;

	int e = -1;
	for (i=0; i<n+m; i++) {
		if (BN[i]==SKUP_N && c[i]>0) {
			e = i;
			break;
		}
	}
	return e;
}

int nadjiIzlaz(int e) {
	int l, i;
	double min;

	l = -1;

	for (i=0; i<m+n; i++) {
		if (BN[i]==SKUP_B && a[i][e]>0) {
			if (l==-1) {
				min = b[i]/a[i][e];
				l = i;
			}
			else {
				if (b[i]/a[i][e] < min) {
					min = b[i]/a[i][e];
					l = i;
				}
			}
		}
	}

	return l;
}

void pivot(int e, int l) {
	int i,j;
	b[e] = b[l]/a[l][e];
	for (j=0; j<n+m; j++) {
		if (BN[j]==SKUP_N && j!=e) {
			a[e][j] = a[l][j]/a[l][e];
		}
	}
	a[e][l] = 1/a[l][e];

	for (i=0; i<n+m; i++) {
		if (BN[i]==SKUP_B && i!=l) {
			b[i] = b[i]-a[i][e]*b[e];
			for (j=0; j<m+n; j++) {
				if (BN[j]==SKUP_N && j!=e) {
					a[i][j] = a[i][j]-a[i][e]*a[e][j];
				}
			}
			a[i][l] = -a[i][e]*a[e][l];
		}
	}

	v = v + c[e]*b[e];
	for (j=0; j<m+n; j++) {
		if (BN[j]==SKUP_N && j!=e) {
			c[j] = c[j]-c[e]*a[e][j];
		}
	}
	c[l] = -c[e]*a[e][l];

	BN[e] = SKUP_B;
	BN[l] = SKUP_N;
}

int main() {
	int e, l;
	int j;

	UnesiPodatke();

	while ( (e=nadjiUlaz())!=-1 ) {
		l = nadjiIzlaz(e);
		if (l==-1) {
			printf("Problem neogranicen.\n");
			break;
		}
		else {
			pivot(e,l);
		}
	}

	if (e==-1) {
		for (j=0; j<n; j++) {
			if (BN[j]==SKUP_B) {
				x[j] = b[j];
			}
			else {
				x[j] = 0;
			}
		}

        //printf("%lf\n", v);
        stoloviKomada = (int)x[0];
        stoliceKomada = (int)x[1];
        gradjaTona = x[2];
        zarada = Csto*stoloviKomada + Cstolica*stoliceKomada + Cgradja*gradjaTona;
        printf("%lf\n", zarada);
        printf("%d\n%d\n", stoloviKomada, stoliceKomada);
        printf("%lf\n", gradjaTona);


	}

	return 0;
}












