#include<stdio.h>
#include<stdlib.h>

#define BESKONACNO -1.0
#define ODREDJEN 1
#define NEODREDJEN 0
#define NEMA -1
#define TRUE 1
#define FALSE 0

int n, m, start, kraj;
double tezina, rezervoar, potrosnja, vremeDopune;

double *gorivo;

double **duzine, **tezine, **brzine;

double *vremena;

int *status,*prethodnik,*potrebnaDopuna;

void zauzmi();
void oslobodi();
int manje(int a, int b);
int odabir();

int main()
{
	int i, j, p, k, kandidat,postojiDopuna;
	double predlogPotrosnje,predlogVremena;
	
	scanf("%d%d",&n,&m);
	
	zauzmi();
	
	//inicijalizacija podataka
	for(i = 0; i < n ; i++)
	{
		vremena[i] = BESKONACNO;
		gorivo[i] = 0.0;
		status[i] = NEODREDJEN;
		prethodnik[i] = NEMA;
		potrebnaDopuna[i] = FALSE;
		
		for(j = 0; j < n ; j++)
			duzine[i][j] = tezine[i][j] = 
				brzine[i][j] = BESKONACNO;
	}
	
	for(i = 0; i < m; i++)
	{
		scanf("%d%d",&p, &k);
		
		scanf("%lf",&brzine[p][k]);
		brzine[k][p] = brzine[p][k];
		
		scanf("%lf",&tezine[p][k]);
		tezine[k][p] = tezine[p][k];
		
		scanf("%lf",&duzine[p][k]);
		duzine[k][p] = duzine[p][k];
	}
	
	scanf("%lf%lf%lf%lf",&tezina,&rezervoar,&potrosnja,&vremeDopune);
	scanf("%d%d",&start,&kraj);
	
	gorivo[start] = rezervoar;
	vremena[start] = 0.0;
	
	while(TRUE)
	{
		kandidat = odabir();
		status[kandidat] = ODREDJEN;
		if(kandidat == kraj) break;
		
		for(i = 0; i < n ; i++)
			if((duzine[kandidat][i] != BESKONACNO) &&
			    (status[i] == NEODREDJEN) && (tezine[kandidat][i] >= tezina))
			{
				postojiDopuna = FALSE;
				
				predlogPotrosnje = duzine[kandidat][i] * potrosnja / 100.0;
				predlogVremena = vremena[kandidat] + duzine[kandidat][i] / brzine[kandidat][i];
				
				if(predlogPotrosnje > gorivo[kandidat])
				    postojiDopuna = TRUE;
				
				if(postojiDopuna)
					predlogVremena += vremeDopune;
				
				if(manje(predlogVremena, vremena[i]))
				{
					vremena[i] = predlogVremena;
					prethodnik[i] = kandidat;
					if(postojiDopuna)
					{
						potrebnaDopuna[i] = TRUE;
						gorivo[i] = rezervoar - predlogPotrosnje;
					}
					else
					{
						gorivo[i] = gorivo[kandidat] - predlogPotrosnje;
					}
				}
			}
	}
	
	//vreme
	printf("%.2lf\n",vremena[kraj]);
	//kontrolne tacke najkraceg puta
	kandidat = kraj;
	while(kandidat != start)
	{
		printf("%-5d",kandidat);
		kandidat = prethodnik[kandidat];
	}
	
	printf("%-5d\n",kandidat);
	//kontrolne tacke dopuna gorivom
	kandidat = kraj;
	while(kandidat != start)
	{
		if(potrebnaDopuna[kandidat]) printf("%-5d",prethodnik[kandidat]);
		kandidat = prethodnik[kandidat];
	}
	
	printf("\n");
	
	oslobodi();
	
	return 0;
}

int odabir()
{
	int i = 0, rezultat = BESKONACNO;
	
	while(i < n && ((vremena[i] == BESKONACNO) || status[i] == ODREDJEN))
		i++;
	
	rezultat = i;
	
	while(i < n)
	{
		if((vremena[i] != BESKONACNO) && (status[i] == NEODREDJEN))
		{
			if(vremena[i] < vremena[rezultat]) rezultat = i;
		}
		i++;
	}
	
	return rezultat;
}

void zauzmi()
{
	int i;
	duzine = (double **)malloc(n * sizeof(double *));
	for(i = 0; i < n ; i++)
	    duzine[i] = (double *)malloc(n * sizeof(double));
	
	tezine = (double **)malloc(n * sizeof(double *));
	for(i = 0; i < n ; i++)
	    tezine[i] = (double *)malloc(n * sizeof(double));
	
	brzine = (double **)malloc(n * sizeof(double *));
	for(i = 0; i < n ; i++)
	    brzine[i] = (double *)malloc(n * sizeof(double));
	
	vremena = (double*)malloc(n * sizeof(double));
	gorivo = (double*)malloc(n * sizeof(double));
	
	status = (int*)malloc(n * sizeof(int));
	prethodnik = (int*)malloc(n * sizeof(int));
	potrebnaDopuna = (int*)malloc(n * sizeof(int));
}

void oslobodi()
{
	int i;
	for(i = 0; i < n ; i++)
	    free(duzine[i]);
	
	for(i = 0; i < n ; i++)
	    free(tezine[i]);
		
	for(i = 0; i < n ; i++)
	    free(brzine[i]);
	
	free(duzine);
	free(tezine);
	free(brzine);
	
	free(vremena);
	free(gorivo);
	free(status);
	free(prethodnik);
	free(potrebnaDopuna);
}

int manje(int a, int b)
{
	if(a == BESKONACNO) return FALSE;
	else if(b == BESKONACNO) return TRUE;
		else return (a < b);
}
