#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#define UNDEF -1
#define INF -1.0
#define TRUE 1
#define FALSE 0

typedef struct stanicaT
{
	double x;
	double y;
	double z;
} stanica;

int **zastavice;

int brojStanica, brojDeonica,  *prethodnik, *odredjen;
int start,kraj;
stanica *stanice;
double **mreza, *prolaz,vremez = 0;
double koef;

double dist(int s1,int s2)
{
    double dx = stanice[s1].x - stanice[s2].x;
	double dy = stanice[s1].y - stanice[s2].y;
	double dz = stanice[s1].z - stanice[s2].z;
	
	dx *= dx;
	dy *= dy;
	dz *= dz;
	
	return sqrt(dx + dy + dz);
}

double time(int s1, int s2)
{
    double d = dist(s1,s2);
	double dz = fabs(stanice[s1].z - stanice[s2].z);
	double t = d / (koef * (dz / d));
	return t;
}


int manje(double a,double b)
{
	if(a == INF)
		return FALSE;
	else
		if(b == INF)
			return TRUE;
		else return a < b;
}

int kandidat()
{
	int i;
	int rezultat = UNDEF;
	int ima = FALSE;
	for(i = 0; i < brojStanica; i++)
		if(!odredjen[i])
		{
			if(ima)
			{
				if(manje(prolaz[i],prolaz[rezultat]))
					rezultat = i;
			}
			else
			{
				rezultat = i;
				ima = TRUE;
			}
		}
	return rezultat;
}

int relax(int node)
{
	int i;
	for(i = 0; i < brojStanica; i++)
		if((mreza[node][i] != INF) && !odredjen[i] && 
			manje(prolaz[node] + mreza[node][i],prolaz[i]))
		{
			prolaz[i] = prolaz[node] + mreza[node][i];
			prethodnik[i] = node;
		}
			
}

void put(int trenutni)
{
	if (trenutni != start)
		put(prethodnik[trenutni]);
	printf("%-5d",trenutni);
}

int main()
{
	int i,j, zaObradu;
	int ds,dk,bz,up,down;
	double vreme;
	scanf("%lf",&koef);
	scanf("%d",&brojStanica);
	
	mreza = (double**)malloc(sizeof(double*) * brojStanica);
	zastavice = (int**)malloc(sizeof(int*) * brojStanica);
	for(i = 0; i < brojStanica ; i++)
	{
		mreza[i] = (double*)malloc(sizeof(double) * brojStanica);
		zastavice[i] = (int*)malloc(sizeof(int) * brojStanica);
		for(j = 0; j < brojStanica ; j++)
			{mreza[i][j] = INF;
			zastavice[i][j] = 0;
			}
	}
	
	odredjen = (int*)malloc(sizeof(int) * brojStanica);
	prethodnik = (int*)malloc(sizeof(int) * brojStanica);
	prolaz = (double*)malloc(sizeof(double) * brojStanica);
	stanice = (stanica*)malloc(sizeof(stanica) * brojStanica);
	
	for(i = 0; i < brojStanica ; i++)
	{
		prethodnik[i] = UNDEF;
		prolaz[i] = INF;
		odredjen[i] = FALSE;
		scanf("%lf%lf%lf",&stanice[i].x,&stanice[i].y,&stanice[i].z);
	}
	
	scanf("%d%d",&start,&kraj);
		
	scanf("%d",&brojDeonica);
	
	for(i = 0; i < brojDeonica; i++)
	{
		scanf("%d%d%d",&ds,&dk,&bz);
		
		if(stanice[ds].z > stanice[dk].z)
		{
			up = ds;
			down = dk;
		}
		else
		{
			up = dk;
			down = ds;
		}
		zastavice[up][down] = bz;
		vreme = time(up,down);
		mreza[up][down] = vreme;
	}
	
	scanf("%lf",&vremez);
	
	for(i = 0; i < brojStanica ; i++)
		for(j = 0; j < brojStanica ; j++)
		{
			if(mreza[i][j] != INF)
				mreza[i][j] += vremez * zastavice[i][j];
		}

	prolaz[start] = 0.0;
	
	while((zaObradu = kandidat()) != UNDEF)
	{
		relax(zaObradu);
		odredjen[zaObradu] = TRUE;
	}
	
	printf("%lf\n",prolaz[kraj]);
	
	put(kraj);
}
