#include<stdio.h>

#define NIZ_DIM 100 //n i m <= 50

#define IZ_N 0
#define IZ_B 1

FILE *ulaz,*izlaz;

int NB[NIZ_DIM]; //dimenzija je n + m zbog lakseg izvodjenja transformacije
                 //PIVOT kojima se ulazne prevode u izlazne u labavom obliku
                 //0 - clan N, 1 - clan B
double A[NIZ_DIM][NIZ_DIM]; //matrica koeficijenata ogranicenja - postoje 
						   //"ogromne neiskoriscenje oblasti" ove matrice u toku iteracija
						   //kako bi se dobilo na jednostavnosti realizacije

double c[NIZ_DIM];//koeficijenti ciljne funkcije
double v;//slobodni clan ciljne funkcije

double b[NIZ_DIM];//slobodni clanovi ogranicenja

double x[NIZ_DIM];//vrednosti promenljivih

int n,m;//dimenzije promenljivih i ogranicenja

//PIVOT funkcija transformacije
void Pivot(int e,int l)
{
	int i,j;
	//racun koef. jednacina za novu osnovnu prom. indeksa e
	b[e] = b[l] / A[l][e];
	for(j = 0; j < (n+m); j++)
		if((NB[j] == IZ_N) && (j != e))
		A[e][j] = A[l][j] / A[l][e];
	A[e][l] = 1 / A[l][e];
	//racuna koef. za ostala ogranicenja
	for(i = 0;i < (n+m); i++)
		if((NB[i] == IZ_B) && (i != l))
		{
			b[i] = b[i] - A[i][e]*b[e];
			for(j = 0; j < (n+m); j++)
				if((NB[j] == IZ_N) && (j != e))
					A[i][j] = A[i][j] - A[i][e]*A[e][j];
			A[i][l] = -A[i][e]*A[e][l];
		}
	//racun ciljne funkcije
	v = v + c[e]*b[e];
	for(j = 0;j < (n + m); j++)
		if((NB[j] == IZ_N) && (j != e)) 
			c[j] = c[j] - c[e]*A[e][j];
	c[l] = -c[e]*A[e][l];
	//racun novog skupa osnovnih i sporednih promenljivih
	NB[l] = IZ_N;
	NB[e] = IZ_B;
	return;
}

int PostojiUlazna()
{
	int indeksUlazne = -1,i;
	
	for(i = 0; i < (n + m); i++)
		if((NB[i] == IZ_N) && (c[i] > 0))
		{
			indeksUlazne = i;
			break;
		}
	
	return indeksUlazne;
}

void PostojiIzlazna(int *l,int *postojiIzlazna,int e)
{
	double delta;
	int i = 0;
	*postojiIzlazna = 0;
	*l = -1;
	
	//pokusaj pronaci prvu izlaznu
	while(!( (NB[i] == IZ_B) && (A[i][e] > 0) ) && (i < (n + m))) i++;
	
	//da li je nadjena?
	if(((NB[i] == IZ_B) && (A[i][e] > 0) ) && (i < (n + m)))
	{
		*postojiIzlazna = 1;
		*l = i;
		delta = b[i] / A[i][e];
	}
	
	//ako je uposte nadjena, proveri da li postoje "bolje"
	if (*postojiIzlazna)
		while(i < (n + m))
		{
			if((NB[i] == IZ_B) && (A[i][e] > 0))
			{
				if(delta > (b[i] / A[i][e]))
				{
					*l = i;
					delta = b[i] / A[i][e];
				}
			}
			i++;
		}
	
	return;
}

void UnesiPodatke();

void IzveziPodatke();

void NeogranicenProblem();

int main(int argc,char *argv[])
{
	int i,e,l,postojiIzlazna = 0;
	
	UnesiPodatke();
	
	while((e = PostojiUlazna()) != -1) //ima li prostora za uvecanje ciljne f-je?
	{
		PostojiIzlazna(&l,&postojiIzlazna,e);//ispitati egzistenciju izlazne
		
		if(postojiIzlazna)
			{
				Pivot(e,l);//ako obe postoje izvrsiti transformacije
			}
		else
			break;//ako ne, prekinuti
	}
	
	if(postojiIzlazna)//resenje
	{
		for(i = 0; i < n; i++)
			if(NB[i] == IZ_B)
				x[i] = b[i];
			else
				x[i] = 0;
		IzveziPodatke();
	}
	else
		NeogranicenProblem();
	
	return 0;
}

void UnesiPodatke()
{
	int i,j;
	n = 3;
	m = 2;
	
	for(i = 0; i < (n + m); i++)
		for(j = 0; j < (n + m); j++)
			A[i][j] = 0;
	
	for(i = 0; i < n + m; i++)
	{
		if(i < n)
		{
			NB[i] = IZ_N;
			scanf("%lf",&c[i]);
		}
		else
		{
			NB[i] = IZ_B;
			c[i] = 0;
		}
	}
	
	v = 0.0;
	
	for(j = 0; j < m + n; j++)
		if(j < n)
			b[j] = 0;
		else
			scanf("%lf",&b[j]);
	
	A[n][0] = 0.15;
	A[n][1] = 0.45;
	A[n][2] = 0.75;
	
	A[n+1][0] = 0.85;
	A[n+1][1] = 0.55;
	A[n+1][2] = 0.25;
}

void IzveziPodatke()
{
	int i;
	printf("%12.2lf\n",v);
	for(i = 0; i < n ; i++)
		printf("%12.2lf ",x[i]);
}

void NeogranicenProblem()
{
	printf("\nProblem neogranicen\n");
}
