#include<stdio.h>
#include<stdlib.h>

#define MAX 100
#define BESKONACNO -1

#define TRUE 1
#define FALSE 0

typedef struct pobustava {
	int prviGrad;
	int drugiGrad;
	int pocetak;
	int kraj;
} obustava;

int brojGradova,pocetni,krajnji,satPolaska;
int brojPuteva,brojObustava;
int **mreza;//tezinski graf
obustava *obustave;//niz obustava - radovi

int *satPosete;//kad je grad posecen, u kom satu
int *utvrdjen;
int *prethodnik;
int *ruta;
int brojGradovaURuti;

int Kandidat();

int ProveriDeonicu(int trenutniGrad,int noviGrad,int trenutnoVreme);

void PlanirajPut();

int main(int argc,char *argv[])
{
	int i,j,s,e,t,k;
	
	//ucitavanje ulaza
	scanf("%d",&brojGradova);
	scanf("%d%d",&pocetni,&krajnji);
	scanf("%d",&satPolaska);
	scanf("%d",&brojPuteva);
	
	satPosete = (int*)calloc(brojGradova,sizeof(int));
	utvrdjen = (int*)calloc(brojGradova,sizeof(int));	
	prethodnik = (int*)calloc(brojGradova,sizeof(int));
	ruta = (int*)calloc(brojGradova,sizeof(int));
	
	for(i=0;i<brojGradova;i++) satPosete[i] = BESKONACNO;
	for(i=0;i<brojGradova;i++) utvrdjen[i] = FALSE;
	for(i=0;i<brojGradova;i++) prethodnik[i] = -1;
	for(i=0;i<brojGradova;i++) ruta[i] = -1;
	
	mreza=(int**)calloc(brojGradova,sizeof(int*));
	for(i=0;i<brojGradova;i++) mreza[i]=(int*)calloc(brojGradova,sizeof(int));
	
	for(i=0;i<brojGradova;i++)
		for(j=0;j<brojGradova;j++)
			mreza[i][j] = BESKONACNO;
	
	for(i=0;i<brojPuteva;i++)
	{
		scanf("%d%d%d",&s,&e,&t);
		mreza[s][e]=mreza[e][s]=t;
	}
	
	scanf("%d",&brojObustava);
	
	obustave=(obustava*)calloc(brojObustava,sizeof(obustava));
	
	for(i=0;i<brojObustava;i++)
	{
		scanf("%d%d%d%d",&s,&e,&t,&k);
		obustave[i].prviGrad = s;
		obustave[i].drugiGrad = e;
		obustave[i].pocetak = t;
		obustave[i].kraj = k;
	}
	
	//algoritam
	PlanirajPut();
	
	//ispis resenja
	if(satPosete[krajnji] != BESKONACNO)
	{
		printf("%d\n",satPosete[krajnji] - satPosete[pocetni]);
		//rekonkstrukcija rute
		brojGradovaURuti = 0;
		ruta[brojGradovaURuti] = krajnji;
		brojGradovaURuti++;
		int dalje = krajnji;
		while(prethodnik[dalje] != -1)
		{
			ruta[brojGradovaURuti] = prethodnik[dalje];
			brojGradovaURuti++;
			dalje=prethodnik[dalje];
		}
		for(i=brojGradovaURuti-1;i>=0;i--)
			printf("%d\t",ruta[i]);
	}
	else
		printf("BLOKADA");
	
	return 0;
}

int Kandidat()
{
	int i;
	int kandidat = -1;
	for(i=0;i<brojGradova;i++)
		if(satPosete[i] != BESKONACNO && !utvrdjen[i])
		{
			if(kandidat != -1)
			{
				if(satPosete[kandidat] > satPosete[i])
					kandidat = i;
			}
			else
				kandidat = i;
		}
	return kandidat;
}

void PlanirajPut()
{
	satPosete[pocetni] = satPolaska;
	int zaObradu,i;
	
	while((zaObradu = Kandidat()) != -1)
	{
		utvrdjen[zaObradu] = TRUE;
		for(i=0;i<brojGradova;i++)
			if(DeonicaProhodna(zaObradu,i,satPosete[zaObradu]) && ( (satPosete[i] == BESKONACNO) || (satPosete[i] > satPosete[zaObradu] + mreza[zaObradu][i])))
			{
				prethodnik[i] = zaObradu;
				satPosete[i] = satPosete[zaObradu] + mreza[zaObradu][i];
			}
	}
	
	return;
}

int DeonicaProhodna(int trenutniGrad,int noviGrad,int trenutnoVreme)
{
	int prohodno = 0;
	
	int povezani = (mreza[trenutniGrad][noviGrad] != BESKONACNO); //gradovi povezani
	
	if(povezani)
	{
		prohodno = 1;//ako su povezani prohodno je ako nema radova u datoms vremenu

		int pr,kr;
		int i,novoVreme = trenutnoVreme + mreza[trenutniGrad][noviGrad];
		for(i=0;(i<brojObustava) && prohodno;i++)//prolazi kroz sve obustave i ispituj
			if((obustave[i].prviGrad == trenutniGrad && obustave[i].drugiGrad == noviGrad) ||
			(obustave[i].drugiGrad == trenutniGrad && obustave[i].prviGrad == noviGrad))
			{
				pr = obustave[i].pocetak;
				kr = obustave[i].kraj;
				prohodno = prohodno && !( (novoVreme > pr) && (trenutnoVreme < kr) ); //da li ima planiranih radova kad bi on ovako prosao
			}
	}
	
	return prohodno;
}
