﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace StudentiApp
{
    /// <summary>
    /// Interaction logic for StudentiPoSmerovima.xaml
    /// </summary>
    public partial class StudentiPoSmerovima : Window
    {
        public StudentiPoSmerovima()
        {
            InitializeComponent();

            DodajSmerove();
        }

        private void DodajSmerove()
        {
            StudijeDataContext sdc = new StudijeDataContext();
            var smerovi = sdc.Smers; //from s in sdc.Smers select new { Naziv = s.Nazivs };

            cb_Smerovi.ItemsSource = smerovi; 

            cb_Smerovi.SelectedIndex = 0;

        }

        private void cb_Smerovi_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            StudijeDataContext sdc = new StudijeDataContext();

            Smer smer = (Smer)cb_Smerovi.SelectedItem;
            int sSmer = smer.Ssmer;

            /*
                select s.Indeks, s.Upisan, avg(ocena * 1.0)
                from Studenti s join Prijave p on s.Indeks = p.Indeks and s.Upisan = p.Upisan
                where s.Ssmer = 2
                group by s.Indeks, s.Upisan
             */

            var proseci = from s in sdc.Studentis
                          where s.Ssmer == sSmer
                          join p in sdc.Prijaves
                          on new { Indeks = s.Indeks, Upisan = s.Upisan } equals new { Indeks = p.Indeks.Value, Upisan = p.Upisan.Value } into oceneStudenta
                          select new
                          {
                              Ime = s.Imes,
                              Mesto = s.Mesto,
                              //ispiti = oceneStudenta
                              prosek = oceneStudenta.Average( p => p.Ocena * 1.0)
                          };

            lv_studenti.ItemsSource = proseci;

            
        }
    }
}
